/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HPGL
extends Output {
    private static final double SCALE = 100.0;
    private HashMap<Layer, List<PolyBase>> cellGeoms;
    private LinkedHashMap<Color, Integer> penNumbers = new LinkedHashMap();
    private int currentLineType;
    private int currentPen;
    private boolean fillEmitted;
    private PenColor[] penColorTable;
    private final EditingPreferences ep;
    private HPGLPreferences localPrefs;

    private HPGL(EditingPreferences ep, HPGLPreferences hp) {
        this.ep = ep;
        this.localPrefs = hp;
    }

    protected void start() {
        this.cellGeoms = new HashMap();
        this.currentLineType = -1;
        this.currentPen = -1;
        this.fillEmitted = false;
        this.initPenData();
    }

    protected void done() {
        this.writeLine("\u001b%0BBPIN");
        this.writeLine("LA1,4,2,4QLMC0");
        for (Map.Entry<Layer, List<PolyBase>> entry : this.cellGeoms.entrySet()) {
            Color col;
            Layer layer = entry.getKey();
            List<PolyBase> geoms = entry.getValue();
            if (layer == null) {
                col = Color.BLACK;
            } else {
                col = this.localPrefs.layerColors.get(layer);
                if (col == null) continue;
            }
            this.getPenNumber(col);
            for (PolyBase poly : geoms) {
                EGraphics graphicsOverride;
                if (!(poly instanceof Poly) || (graphicsOverride = ((Poly)poly).getGraphicsOverride()) == null) continue;
                this.getPenNumber(graphicsOverride.getColor());
            }
        }
        this.writeLine("NP" + this.penNumbers.size());
        for (Map.Entry<Serializable, Object> entry : this.penNumbers.entrySet()) {
            Color col = (Color)entry.getKey();
            int index = (Integer)entry.getValue();
            int r = col.getRed();
            int g = col.getGreen();
            int b = col.getBlue();
            this.writeLine("PC" + index + "," + r + "," + g + "," + b);
        }
        this.writeLine("IP;");
        this.writeLine("SC" + this.makeCoord(this.localPrefs.printBounds.getMinX()) + ",1," + this.makeCoord(this.localPrefs.printBounds.getMinY()) + ",1,2;");
        for (Map.Entry<Serializable, Object> entry : this.cellGeoms.entrySet()) {
            List geoms = (List)entry.getValue();
            for (PolyBase poly : geoms) {
                this.emitPoly(poly);
            }
        }
        this.writeLine("PUSP0PG;");
    }

    private HPGLVisitor makeHPGLVisitor() {
        HPGLVisitor visitor = new HPGLVisitor(this);
        return visitor;
    }

    private void emitPoly(PolyBase poly) {
        EGraphics graphicsOverride;
        Layer layer = poly.getLayer();
        Color col = this.localPrefs.layerColors.get(layer);
        if (poly instanceof Poly && (graphicsOverride = ((Poly)poly).getGraphicsOverride()) != null) {
            col = graphicsOverride.getColor();
        }
        Poly.Type style = poly.getStyle();
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            FixpRectangle box = poly.getBox();
            if (box != null) {
                if (((RectangularShape)box).getWidth() == 0.0) {
                    if (((RectangularShape)box).getHeight() != 0.0) {
                        this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), col);
                    }
                    return;
                }
                if (((RectangularShape)box).getHeight() == 0.0) {
                    this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), col);
                    return;
                }
            }
            if (points.length <= 1) {
                return;
            }
            if (points.length == 2) {
                this.emitLine(((Point2D)points[0]).getX(), points[0].getY(), points[1].getX(), points[1].getY(), col);
                return;
            }
            this.emitFilledPolygon(points, col);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int k;
            FixpRectangle box = poly.getBox();
            if (box != null) {
                this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), col);
                this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMaxY(), col);
                this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMaxY(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), col);
                if (style == Poly.Type.CLOSED || points.length == 5) {
                    this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), col);
                }
                return;
            }
            for (k = 1; k < points.length; ++k) {
                this.emitLine(points[k - 1].getX(), points[k - 1].getY(), points[k].getX(), points[k].getY(), col);
            }
            if (style == Poly.Type.CLOSED) {
                k = points.length - 1;
                this.emitLine(points[k].getX(), points[k].getY(), points[0].getX(), points[0].getY(), col);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int k = 0; k < points.length; k += 2) {
                this.emitLine(points[k].getX(), points[k].getY(), points[k + 1].getX(), points[k + 1].getY(), col);
            }
            return;
        }
        if (style == Poly.Type.CROSS || style == Poly.Type.BIGCROSS) {
            double x = poly.getCenterX();
            double y = poly.getCenterY();
            this.emitLine(x - 5.0, y, x + 5.0, y, col);
            this.emitLine(x, y + 5.0, x, y - 5.0, col);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            FixpRectangle box = poly.getBounds2D();
            this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), col);
            this.emitLine(((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMaxY(), col);
            this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMaxY(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), col);
            this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), col);
            this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMaxY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMinY(), col);
            this.emitLine(((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxY(), col);
            return;
        }
        if (style == Poly.Type.DISC) {
            this.emitDisc(points[0], points[1], col);
            style = Poly.Type.CIRCLE;
        }
        if (style == Poly.Type.CIRCLE || style == Poly.Type.THICKCIRCLE) {
            this.emitCircle(points[0], points[1], col);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            this.emitArc(points[0], points[1], points[2], col);
            return;
        }
        if (style.isText()) {
            EditWindow0 wnd = null;
            Poly textPoly = (Poly)poly;
            double size = textPoly.getTextDescriptor().getTrueSize(wnd);
            FixpRectangle box = textPoly.getBounds2D();
            this.emitText(style, ((RectangularShape)box).getMinX(), ((RectangularShape)box).getMaxX(), ((RectangularShape)box).getMinY(), ((RectangularShape)box).getMaxY(), size, textPoly.getString(), col);
            return;
        }
    }

    void emitLine(double x1, double y1, double x2, double y2, Color col) {
        this.doPenSelection(col);
        this.movePen(x1, y1);
        this.drawPen(x2, y2);
    }

    private void emitArc(Point2D center, Point2D p1, Point2D p2, Color col) {
        double endAngle;
        double startAngle = GenMath.figureAngle(center, p1);
        double amt = startAngle > (endAngle = (double)GenMath.figureAngle(center, p2)) ? (startAngle - endAngle + 5.0) / 10.0 : (startAngle - endAngle + 3600.0 + 5.0) / 10.0;
        this.doPenSelection(col);
        this.movePen(p1.getX(), p1.getY());
        this.writeLine("PD;");
        this.writeLine("AA " + this.makeCoord(center.getX()) + " " + this.makeCoord(center.getY()) + " " + (int)(-amt) + ";");
        this.writeLine("PU;");
    }

    private void emitCircle(Point2D at, Point2D e, Color col) {
        double radius = at.distance(e);
        this.doPenSelection(col);
        this.movePen(at.getX(), at.getY());
        this.writeLine("PD;");
        this.writeLine("CI " + this.makeCoord(radius) + ";");
        this.writeLine("PU;");
    }

    private void emitDisc(Point2D at, Point2D e, Color col) {
        int fillType = this.doFillSelection(col);
        double radius = at.distance(e);
        this.movePen(at.getX(), at.getY());
        this.writeLine("PD;");
        this.writeLine("PM;");
        this.writeLine("CI " + this.makeCoord(radius) + ";");
        this.writeLine("PM2;");
        if (fillType != 0) {
            this.writeLine("FP;");
        }
        if (fillType != 1) {
            this.writeLine("EP;");
        }
        this.writeLine("PU;");
    }

    private void emitFilledPolygon(Point2D[] points, Color col) {
        if (points.length <= 1) {
            return;
        }
        int fillType = this.doFillSelection(col);
        double firstX = points[0].getX();
        double firstY = points[0].getY();
        this.movePen(firstX, firstY);
        this.writeLine("PM;");
        for (int i = 1; i < points.length; ++i) {
            this.drawPen(points[i].getX(), points[i].getY());
        }
        this.drawPen(firstX, firstY);
        this.writeLine("PM2;");
        if (fillType != 0) {
            this.writeLine("FP;");
        }
        if (fillType != 1) {
            this.writeLine("EP;");
        }
    }

    private void emitText(Poly.Type type, double xl, double xh, double yl, double yh, double size, String text, Color col) {
        this.writeLine("SI " + TextUtils.formatDouble(size * 0.01 / 1.3) + "," + TextUtils.formatDouble(size * 0.01) + ";");
        this.doPenSelection(col);
        if (type == Poly.Type.TEXTBOTLEFT) {
            this.movePen(xl, yl);
            this.writeLine("LO1;");
        } else if (type == Poly.Type.TEXTLEFT) {
            this.movePen(xl, (yl + yh) / 2.0);
            this.writeLine("LO2;");
        } else if (type == Poly.Type.TEXTTOPLEFT) {
            this.movePen(xh, yl);
            this.writeLine("LO3;");
        } else if (type == Poly.Type.TEXTBOT) {
            this.movePen((xl + xh) / 2.0, yl);
            this.writeLine("LO4;");
        } else if (type == Poly.Type.TEXTCENT || type == Poly.Type.TEXTBOX) {
            this.movePen((xl + xh) / 2.0, (yl + yh) / 2.0);
            this.writeLine("LO5;");
        } else if (type == Poly.Type.TEXTTOP) {
            this.movePen((xl + xh) / 2.0, yh);
            this.writeLine("LO6;");
        } else if (type == Poly.Type.TEXTBOTRIGHT) {
            this.movePen(xh, yl);
            this.writeLine("LO7;");
        } else if (type == Poly.Type.TEXTRIGHT) {
            this.movePen(xh, (yl + yh) / 2.0);
            this.writeLine("LO8;");
        } else if (type == Poly.Type.TEXTTOPRIGHT) {
            this.movePen(xh, yh);
            this.writeLine("LO9;");
        }
        this.writeLine("LB " + text + "\u0003");
    }

    private void initPenData() {
        this.penColorTable = new PenColor[256];
        for (int i = 0; i < 256; ++i) {
            this.penColorTable[i] = new PenColor();
            this.penColorTable[i].lineType = 0;
            this.penColorTable[i].fillType = 3;
            this.penColorTable[i].fillDist = this.makeCoord(i * 2);
            this.penColorTable[i].fillAngle = i * 10 % 360;
        }
    }

    private int getPenNumber(Color color) {
        Integer ind = this.penNumbers.get(color);
        if (ind == null) {
            ind = this.penNumbers.size() + 1;
            this.penNumbers.put(color, ind);
        }
        return ind;
    }

    private int doFillSelection(Color col) {
        this.doPenSelection(col);
        int fillType = this.penColorTable[this.currentPen].fillType;
        if (!this.fillEmitted) {
            int fillAngle = this.penColorTable[this.currentPen].fillAngle;
            int fillDist = this.penColorTable[this.currentPen].fillDist;
            this.writeLine("FT " + fillType + "," + fillDist + "," + fillAngle + ";");
            this.fillEmitted = true;
        }
        return fillType;
    }

    private void doPenSelection(Color col) {
        int pen;
        int desiredPen = pen = this.getPenNumber(col);
        int lineType = this.penColorTable[pen].lineType;
        if (desiredPen < 1) {
            desiredPen = 1;
        }
        if (desiredPen != this.currentPen) {
            this.writeLine("SP" + desiredPen + ";");
            this.currentPen = desiredPen;
            this.fillEmitted = false;
        }
        if (lineType != this.currentLineType) {
            if (lineType == 0) {
                this.writeLine("LT;");
            } else {
                this.writeLine("LT" + lineType + ";");
            }
            this.currentLineType = lineType;
        }
    }

    private void movePen(double x, double y) {
        this.writeLine("PU" + this.makeCoord(x) + "," + this.makeCoord(y) + ";");
    }

    private void drawPen(double x, double y) {
        this.writeLine("PD" + this.makeCoord(x) + "," + this.makeCoord(y) + ";");
    }

    private int makeCoord(double v) {
        return (int)Math.round(v * 100.0);
    }

    private void writeLine(String line) {
        this.printWriter.print(line + "\r\n");
    }

    public static class HPGLPreferences
    extends Output.OutputPreferences {
        boolean textVisibilityOnExport;
        int exportDisplayLevel;
        Map<Layer, Color> layerColors = new HashMap<Layer, Color>();
        EditWindow0.EditWindowSmall wnd;
        Rectangle2D printBounds;
        GraphicsPreferences gp;
        NodeInst.ExpansionState expansionState;

        public HPGLPreferences(boolean factory, Cell cell) {
            super(factory);
            this.gp = new GraphicsPreferences(factory);
            this.textVisibilityOnExport = this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT);
            this.exportDisplayLevel = this.gp.exportDisplayLevel;
            for (Technology tech : TechPool.getThreadTechPool().values()) {
                Color[] transparentColors = factory ? tech.getFactoryTransparentLayerColors() : tech.getTransparentLayerColors();
                Iterator<Layer> it = tech.getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    EGraphics graphics = factory ? layer.getFactoryGraphics() : layer.getGraphics();
                    this.layerColors.put(layer, graphics.getColor(transparentColors));
                }
            }
            if (factory) {
                this.expansionState = new NodeInst.ExpansionState(null, 1);
            } else {
                this.expansionState = new NodeInst.ExpansionState(cell, 2);
                this.fillPrefs(cell);
            }
        }

        private void fillPrefs(Cell cell) {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ localWnd = ui.getCurrentEditWindow_();
            this.wnd = new EditWindow0.EditWindowSmall(localWnd);
            this.printBounds = Output.getAreaToPrint(cell, false, localWnd);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath, EditingPreferences ep) {
            if (this.printBounds == null) {
                return null;
            }
            HPGL out = new HPGL(ep, this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            HPGLVisitor visitor = out.makeHPGLVisitor();
            out.start();
            HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)visitor);
            out.done();
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }

    private class HPGLVisitor
    extends HierarchyEnumerator.Visitor {
        private HPGL outGeom;

        HPGLVisitor(HPGL outGeom) {
            this.outGeom = outGeom;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni;
            return !no.isCellInstance() || HPGL.this.localPrefs.expansionState.isExpanded(ni = no.getNodeInst());
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            FixpTransform trans = info.getTransformToRoot();
            PolyMerge merge = new PolyMerge();
            Cell cell = info.getCell();
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                FixpTransform nodeTrans = ni.rotateOut(trans);
                if (!ni.isCellInstance()) {
                    PrimitiveNode prim = (PrimitiveNode)ni.getProto();
                    Technology tech = prim.getTechnology();
                    Poly[] polys = tech.getShapeOfNode(ni);
                    this.addPolys(polys, nodeTrans, merge);
                    Poly[] textPolys = ni.getDisplayableVariables(HPGL.this.localPrefs.wnd, HPGL.this.localPrefs.gp.isShowTempNames());
                    this.addPolys(textPolys, nodeTrans, merge);
                } else if (!HPGL.this.localPrefs.expansionState.isExpanded(ni)) {
                    Cell subCell = (Cell)ni.getProto();
                    FixpTransform subTrans = ni.translateOut(nodeTrans);
                    ERectangle bounds = subCell.getBounds();
                    Poly poly = new Poly(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), ni.getXSize(), ni.getYSize());
                    poly.transform(subTrans);
                    poly.setStyle(Poly.Type.CLOSED);
                    List<PolyBase> layerList = this.getListForLayer(null);
                    layerList.add(poly);
                    poly = new Poly(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), ni.getXSize(), ni.getYSize());
                    poly.transform(subTrans);
                    poly.setStyle(Poly.Type.TEXTBOX);
                    TextDescriptor td = HPGL.this.ep.getInstanceTextDescriptor().withAbsSize(24);
                    poly.setTextDescriptor(td);
                    poly.setString(ni.getProto().describe(false));
                    layerList.add(poly);
                }
                if (!info.isRootCell() || !HPGL.this.localPrefs.textVisibilityOnExport) continue;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    PolyBase poly = e.getNamePoly();
                    List<PolyBase> layerList = this.getListForLayer(null);
                    if (HPGL.this.localPrefs.exportDisplayLevel == 2) {
                        poly.setStyle(Poly.Type.CROSS);
                        layerList.add(poly);
                        continue;
                    }
                    if (HPGL.this.localPrefs.exportDisplayLevel == 1) {
                        String portName = e.getShortName();
                        ((Poly)poly).setString(portName);
                    }
                    layerList.add(poly);
                }
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ArcProto ap = ai.getProto();
                Technology tech = ap.getTechnology();
                this.addPolys(tech.getShapeOfArc(ai), trans, merge);
                this.addPolys(ai.getDisplayableVariables(HPGL.this.localPrefs.wnd, HPGL.this.localPrefs.gp.isShowTempNames()), trans, merge);
            }
            for (Layer layer : merge.getKeySet()) {
                List<PolyBase> layerList = this.getListForLayer(layer);
                List<PolyBase> geom = merge.getMergedPoints(layer, true);
                for (PolyBase poly : geom) {
                    layerList.add(poly);
                }
            }
        }

        private void addPolys(Poly[] polys, FixpTransform trans, PolyMerge merge) {
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                Layer layer = poly.getLayer();
                if (layer == null || poly.getStyle() != Poly.Type.FILLED) {
                    List<PolyBase> layerList = this.getListForLayer(layer);
                    layerList.add(poly);
                    continue;
                }
                merge.addPolygon(layer, poly);
            }
        }

        private List<PolyBase> getListForLayer(Layer layer) {
            List<PolyBase> layerList = this.outGeom.cellGeoms.get(layer);
            if (layerList == null) {
                layerList = new ArrayList<PolyBase>();
                this.outGeom.cellGeoms.put(layer, layerList);
            }
            return layerList;
        }
    }

    private static class PenColor {
        private int lineType;
        private int fillType;
        private int fillDist;
        private int fillAngle;

        private PenColor() {
        }
    }
}

