.TH gdiffmk @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
gdiffmk \- mark differences between
.IR groff / nroff / troff
files
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2004-2016 Free Software Foundation, Inc.
.\"           2017-2025 G. Branden Robinson
.\"
.\" This file is part of gdiffmk.
.\"
.\" gdiffmk is distributed with groff, the GNU roff typesetting system.
.\"
.\" groff is free software; you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" groff is distributed in the hope that it will be useful, but WITHOUT
.\" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
.\" or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
.\" License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_gdiffmk_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY gdiffmk
.RB [ \-a\~\c
.IR add-mark ]
.RB [ \-c\~\c
.IR change-mark ]
.RB [ \-d\~\c
.IR delete-mark ]
.RB [ \-x\~\c
.IR diff-command ]
.RB [ \-D
.RB [ \-B ]
.RB [ \-M
.IR "mark1 mark2" ]]
.RB [ \-\- ]
.I file1
.I file2
.RI [ output-file ]
.YS
.
.
.P
.SY gdiffmk
.B \-\-help
.YS
.
.
.P
.SY gdiffmk
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I gdiffmk
compares two
.MR roff @MAN7EXT@
documents,
.I file1
and
.IR file2 ,
and writes another,
derived from both,
to the standard output stream
(or
.IR output-file ),
adding margin character
.RB ( mc )
requests at places in the output
where the input documents differ.
.
.I gdiffmk
does not interpret the source documents;
it treats
.I roff
comments and nilpotent changes to formatting as meaningful.
.
For example,
it does not know that
.BR \[rs]h\[aq]3m\[aq] ,
.BR \[rs]h\[aq](1\~*\~3m)\[aq] ,
and
.B \[rs]h\[aq]3m+0\[aq]
all mean the same thing.
.
If the
.I file1
or
.I file2
argument is
.RB \[lq] \- \[rq],
.I gdiffmk
reads the standard input stream for that input.
.
If the
.I output
operand is present,
.I gdiffmk
writes output to a file of that name.
.
If it is
.RB \[lq] \- \[rq]
or absent,
.I gdiffmk
writes output to the standard output stream.
.
.RB \[lq] \- \[rq]
cannot be both an input and output operand.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message
and
.B \%\-\-version
shows version information;
both exit afterward.
.
.
.TP
.BI \-a\~ add-mark
Annotate material absent from
.I file1
but present in
.I file2
with
.I add-mark
(default:
.RB \[lq] + \[rq]).
.
.
.TP
.B \-B
Suppress
.B br
requests normally inserted by
.B \-D
option.
.
Use with caution;
such requests are the only way to guarantee that deletions and small
changes are marked.
.
.
.TP
.BI \-c\~ change-mark
Annotate material differing between
.I file1
and
.I file2
with
.I change-mark
(default:
.RB \[lq] | \[rq]).
.
.
.TP
.BI \-d\~ delete-mark
Annotate material present in
.I file1
but absent from
.I file2
with
.I delete-mark
(default:
.RB \[lq] * \[rq]).
.
.TP
.B \-D
Mark changed and deleted material with surrounding delimiters.
.
.
.TP
.BI \-M\~ "mark1 mark2"
Use
.I mark1
(default:
.RB \[lq] [[ \[rq])
and
.I mark2
(default:
.RB \[lq] ]] \[rq])
as delimiters when using the
.B \-D
option.
.
.
.TP
.BI \-x\~ diff-command
Use the
.I diff-command
program to perform the comparison of
.I file1
and
.IR file2 .
.
.I diff-command
(default:
.BR diff )
must accept GNU
.MR diff 1 's
.B \-D
extension option.
.
.
.TP
.B \-\-
Treat all subsequent arguments as file names,
even if they begin with
.RB \[lq] \- \[rq].
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I gdiffmk
exits with
.RB status\~ 0
if the input files are the same;
.B 1
if they differ;
.B 2
upon a usage error;
.B 3
if the system's
.MR diff 1
or
.MR sh 1
commands do not support features
.I gdiffmk
requires;
and
.B 4
if the
.I output
argument is a duplicate of
.I file1
or
.IR file2 .
.
.\" ====================================================================
.SH Caveats
.\" ====================================================================
.
The output is not necessarily compatible with all macro packages or
preprocessors.
.
A reliable workaround is to run
.I gdiffmk
on the output of the final preprocessor instead of the input source.
.
.
.PP
.I gdiffmk
relies on the
.B \-D
option of GNU
.I diff
.\" The hair space `\^` is a kludge--see Savannah #67544.
to make a merged \[lq]#ifdef\^\[rq] output format.
.
Busybox
.I diff
is known to not support it.
.
Also see the
.BI \-x\~ diff-command
option.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I gdiffmk
was written by
.MT MBianchi@\:Foveal\:.com
Mike Bianchi
.ME ,
now retired.
.
It is maintained by the
.I groff
developers.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff @MAN1EXT@ ,
.MR @g@nroff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR roff @MAN7EXT@ ,
.MR diff 1
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_gdiffmk_1_man_C]
.do rr *groff_gdiffmk_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
