.TH hpftodit @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
hpftodit \- create font description files for use with
.I groff
and
.I grolj4
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1994-2024 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_hpftodit_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY hpftodit
.RB [ \-aqs ]
.RB [ \-i\~\c
.IR n ]
.I tfm-file
.I map-file
.I font-description
.YS
.
.
.P
.SY hpftodit
.B \-d
.I tfm-file
.RI [ map-file ]
.YS
.
.
.P
.SY hpftodit
.B \-\-help
.YS
.
.
.P
.SY hpftodit
.B \-v
.YS
.
.SY hpftodit
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I hpftodit
creates a font description file for use with a Hewlett-Packard
LaserJet\~4-\%series
(or newer)
printer and the
.MR grolj4 @MAN1EXT@
output driver of
.MR groff @MAN1EXT@ ,
using data from an HP tagged font metric (TFM) file.
.
.I tfm-file
is the name of the font's TFM file;
Intellifont and TrueType TFM files are supported,
but symbol set TFM files are not.
.
.I map-file
is a file giving the
.I groff
special character identifiers for glyphs in the font;
this file should consist of a sequence of lines of the form
.RS
.EX
.IR "m u c1 c2 " "\&.\|.\|.\& [#" " comment" "]"
.EE
.RE
where
.I m
is a decimal integer giving the glyph's MSL
(Master Symbol List)
number,
.I u
is a hexadecimal integer giving its Unicode character code,
and
.IR c1 ,
.IR c2 ", .\|.\|."
are its
.I groff
glyph names
(see
.MR groff_char @MAN7EXT@
for a list).
.
The values can be separated by any number of spaces and/or tabs.
.
The Unicode value must use uppercase hexadecimal digits A\^\[en]\^F,
and must lack a leading
.RB \[lq] 0x \[rq],
.RB \[lq] u \[rq],
or
.RB \[lq] U+ \[rq].
.
Unicode values corresponding to composite glyphs are decomposed;
that is
.RB \[lq] u00C0 \[rq]
becomes
.RB \[lq] u0041_0300 \[rq].
.
A glyph without a
.I groff
special character identifier may be named
.BI u XXXX
if the glyph corresponds to a Unicode value,
or as an unnamed glyph
.RB \[lq] \-\-\- \[rq].
.
If the given Unicode value is in the Private Use Area (PUA)
(0xE000\^\[en]\^0xF8FF),
the glyph is included as an unnamed glyph.
.
Refer to
.MR groff_diff @MAN1EXT@
for additional information about unnamed glyphs and how to access them.
.
.
.P
Blank lines and lines beginning with
.RB \[lq] # \[rq]
are ignored.
.
A
.RB \[lq] # \[rq]
following one or more
.I groff
names begins a comment.
.
Because
.RB \[lq] # \[rq]
is a valid
.I groff
name,
it must appear first in a list of
.I groff
names if a comment is included,
as in
.
.RS
.EX
3   0023   #   # number sign
.EE
.RE
.
or
.
.RS
.EX
3   0023   # sh   # number sign
.EE
.RE
.
whereas in
.
.RS
.EX
3   0023   sh #   # number sign
.EE
.RE
.
the first
.RB \[lq] # \[rq]
is interpreted as the beginning of the comment.
.
.
.P
.I hpftodit
writes output to
.I font-description,
a file named for the intended
.I groff
font name;
if this operand is
.RB \[lq] \- \[rq],
.I hpftodit
writes to the standard output stream.
.
The
.B \-i
option directs
.I hpftodit
to automatically generate an italic correction,
a left italic correction,
and a subscript correction for each glyph.
.
See
.MR groff_font @MAN5EXT@ .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-a
Include glyphs in the TFM file that are not included in
.IR map-file .
.
A glyph with corresponding Unicode value is given the name
.RI u XXXX ;
a glyph without a Unicode value is included as an unnamed glyph
\[lq]\-\^\-\^\-\[rq].
.
A glyph with a Unicode value in the Private Use Area
(0xE000\^\[en]\^0xF8FF)
is also included as an unnamed glyph.
.
.
.IP
This option provides a simple means of adding Unicode-named and
unnamed glyphs to a font without including them in the map file,
but it affords little control over which glyphs are placed in a regular
font and which are placed in a special font.
.
The presence or absence of the
.B \-s
option has some effect on which glyphs are included:
without it,
only the \[lq]text\[rq] symbol sets are searched for matching glyphs;
with it,
only the \[lq]mathematical\[rq] symbol sets are searched.
.
Nonetheless,
restricting the symbol sets searched isn't very selective\[em]many
glyphs are placed in both regular and special fonts.
.
Normally,
.B \-a
should be used only as a last resort.
.
.
.TP
.B \-d
Dump information about the TFM file to the standard output stream;
use this to ensure that a TFM file is a proper match for a font,
and that its contents are suitable.
.
The information includes the values of important TFM tags and a listing
(by MSL number for Intellifont TFM files or by Unicode value for
TrueType TFM files)
of the glyphs included in the TFM file.
.
The unit of measure \[lq]DU\[rq] for some tags indicates design units;
there are 8782\~design units per em for Intellifont fonts,
and 2048\~design units per em for TrueType fonts.
.
Note that the accessibility of a glyph depends on its inclusion in a
symbol set;
some TFM files list many glyphs but only a few symbol sets.
.
.
.IP
The glyph listing includes the glyph index within the TFM file,
the MSL or Unicode value,
and the symbol set and character code that will be used to print the
glyph.
.
If
.I map-file
is given,
.I groff
names are given for matching glyphs.
.
If only the glyph index and MSL or Unicode value are given,
the glyph does not appear in any supported symbol set and cannot be
printed.
.
.
.IP
With the
.B \-d
option,
.I map-file
is optional,
and
.I output-font
is ignored if given.
.
.
.TP
.BI \-i\~ n
Generate an italic correction for each glyph so that its width plus its
italic correction is equal to
.I n
thousandths of an em plus the amount by which the right edge of the
glyphs's bounding box is to the right of its origin.
.
The minimum value
.I hpftodit
will write is zero.
.
.
.IP
Also generate a subscript correction equal to the product of the tangent
of the slant of the font and four fifths of the x-height of the font.
.
If a subscript correction greater than the italic correction would
result,
use a subscript correction equal to the italic correction instead.
.
.
.IP
Also generate a left italic correction for each glyph equal to
.I n
thousandths of an em plus the amount by which the left edge of the
glyphs's bounding box is to the left of its origin.
.
The left italic correction may be negative.
.
.
.IP
This option normally is needed only with italic or oblique fonts;
a value of 50
(0.05\~em)
usually is a reasonable choice.
.
.
.TP
.B \-q
Suppress warnings about glyphs in the map file that were not found in
the TFM file.
.
Warnings never are given for unnamed glyphs or by glyphs named by their
Unicode values.
.
This option is useful when sending the output of
.I hpftodit
to the standard output stream.
.
.
.TP
.B \-s
Add the
.B special
directive to the font description file,
affecting the order in which HP symbol sets are searched for each glyph.
.
Without this option,
the \[lq]text\[rq] sets are searched before the \[lq]mathematical\[rq]
symbol sets.
.
With it,
the search order is reversed.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I \%hpftodit
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devlj4/\:DESC
describes the
.B lj4
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devlj4/ F
describes the font known
.RI as\~ F
on device
.BR lj4 .
.
.
.TP
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:\%Makefile
is a
.MR make 1
script that uses
.MR hpftodit @MAN1EXT@
to prepare the
.I groff
font description files above from HP TFM data;
it can be used to regenerate them in the event the TFM files are
updated.
.
.
.TP
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:\%special\:.awk
is an
.MR awk 1
script that corrects the Intellifont-based height metrics for several
glyphs in the
.B S
(special) font for TrueType CG Times used in the HP LaserJet\~4000 and
later.
.
.
.TP
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:\%special\:.map
.TQ
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:\%symbol\:.map
.TQ
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:text\:.map
.TQ
.I @FONTDIR@/\:\%devlj4/\:\%generate/\:\%wingdings.map
map MSL indices and HP Unicode PUA assignments to
.I groff
special character identifiers.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff @MAN1EXT@ ,
.MR groff_diff @MAN1EXT@ ,
.MR grolj4 @MAN1EXT@ ,
.MR groff_font @MAN5EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_hpftodit_1_man_C]
.do rr *groff_hpftodit_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
