--
-- This file is part of TALER
-- Copyright (C) 2014--2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE FUNCTION alter_table_wire_targets3()
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  ALTER TABLE wire_targets
    DROP COLUMN access_token,
    DROP COLUMN aml_program_lock_timeout,
    DROP COLUMN target_pub;
END $$;


CREATE FUNCTION foreign_table_wire_targets3()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'wire_targets';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_fk_kyc_targets'
    ' FOREIGN KEY (h_normalized_payto) REFERENCES kyc_targets (h_normalized_payto)'
  );
END
$$;


INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('wire_targets3'
    ,'exchange-0003'
    ,'alter'
    ,TRUE
    ,FALSE),
    ('wire_targets3'
    ,'exchange-0003'
    ,'foreign'
    ,TRUE
    ,FALSE);
