// SPDX-FileCopyrightText: 2023 Devin Lin <devin@kde.org>
// SPDX-License-Identifier: GPL-2.0-or-later

import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15

import org.kde.kirigami 2.20 as Kirigami

import initialstart 1.0 as InitialStart

Kirigami.ApplicationWindow {
    id: root

    width: 360
    height: 720
    visibility: InitialStart.Wizard.testingMode ? "Windowed" : "FullScreen"

    title: i18n("Initial Start")

    pageStack.globalToolBar.style: Kirigami.ApplicationHeaderStyle.None
    pageStack.columnView.columnResizeMode: Kirigami.ColumnView.SingleColumn

    pageStack.initialPage: Wizard {}
}
