/* -*- mode: c++; c-basic-offset:4 -*-
    commands/exportsecretkeycommand.h

    This file is part of Kleopatra, the KDE keymanager
    SPDX-FileCopyrightText: 2016 Bundesamt für Sicherheit in der Informationstechnik
    SPDX-FileContributor: Intevation GmbH

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef __KLEOPATRA_COMMMANDS_EXPORTPAPERKEYCOMMAND_H__
#define __KLEOPATRA_COMMMANDS_EXPORTPAPERKEYCOMMAND_H__

#include <commands/gnupgprocesscommand.h>

#include <QString>
#include <QProcess>

class QWidget;

namespace Kleo
{
namespace Commands
{

class ExportPaperKeyCommand : public GnuPGProcessCommand
{
    Q_OBJECT

public:
    explicit ExportPaperKeyCommand(QAbstractItemView *view,
                                   KeyListController *parent);

    static Restrictions restrictions()
    {
        return OnlyOneKey | NeedSecretKey | MustBeOpenPGP;
    }

protected Q_SLOTS:
    void pkProcFinished(int code, QProcess::ExitStatus status);

private:
    QStringList arguments() const override;
    bool preStartHook(QWidget *parentWidget) const override;

    QString errorCaption() const override;

    QString crashExitMessage(const QStringList &) const override;
    QString errorExitMessage(const QStringList &) const override;

private:
    QWidget *const mParent;
    QProcess mPkProc;
};

}
}

#endif // __KLEOPATRA_COMMMANDS_EXPORTPAPERKEYCOMMAND_H__
