/*
 *  This file is part of kalarmcal library, which provides access to KAlarm
 *  calendar data.
 *  Copyright © 2011-2012 by David Jarvie <djarvie@kde.org>
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published
 *  by the Free Software Foundation; either version 2 of the License, or (at
 *  your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#ifndef KALARMCAL_EXPORT_H
#define KALARMCAL_EXPORT_H

// This library was built to use Akonadi.
// It must be rebuilt in order to use KResources.
#ifdef KALARMCAL_USE_KRESOURCES
#undef KALARMCAL_USE_KRESOURCES
#endif

/* needed for KDE_EXPORT and KDE_IMPORT macros */
#include <kdemacros.h>

#ifndef KALARMCAL_EXPORT
# if defined(KDEPIM_STATIC_LIBS)
   /* No export/import for static libraries */
#  define KALARMCAL_EXPORT
# elif defined(MAKE_KALARMCAL_LIB)
   /* We are building this library */
#  define KALARMCAL_EXPORT KDE_EXPORT
# else
   /* We are using this library */
#  define KALARMCAL_EXPORT KDE_IMPORT
# endif
#endif

# ifndef KALARMCAL_EXPORT_DEPRECATED
#  define KALARMCAL_EXPORT_DEPRECATED KDE_DEPRECATED KALARMCAL_EXPORT
# endif

#endif
