/**
 * ./src/classes/compressors.ts
 * penguins-eggs v.25.11.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class Compressors {
    dest: string;
    isEnabled: {
        error: boolean;
        gzip: boolean;
        lz4: boolean;
        lzma: boolean;
        lzo: boolean;
        xz: boolean;
        zstd: boolean;
    };
    source: string;
    /**
     * fast compression
     */
    fast(): string;
    /**
     * max
     */
    max(): string;
    pendrive(level?: string): string;
    /**
     * populate
     * Manteniamo async per compatibilità con chi lo chiama,
     * ma internamente ora è tutto sincrono e veloce.
     */
    populate(): Promise<void>;
    /**
     * standard
     */
    standard(): string;
    /**
     * check mksquashfs exists and supports compressor
     */
    private check;
    /**
     * prepareCheck: Usa FS nativo invece di shelljs
     */
    private prepareCheck;
    /**
     * removeCheck: Usa FS nativo invece di shelljs
     */
    private removeCheck;
}
