/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class FileFinder {
    public static List<VirtualFile> findPomFiles(VirtualFile[] roots, boolean lookForNested, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (indicator == null) {
            FileFinder.$$$reportNull$$$0(0);
        }
        return FileFinder.findPomFiles(roots, lookForNested, indicator.getIndicator());
    }

    public static List<VirtualFile> findPomFiles(VirtualFile[] roots, final boolean lookForNested, final @Nullable ProgressIndicator indicator) throws MavenProcessCanceledException {
        final ArrayList result2 = new ArrayList();
        for (VirtualFile f : roots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean visitFile(@NotNull VirtualFile f) {
                    if (f == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (null != indicator) {
                            indicator.checkCanceled();
                            indicator.setText2(f.getPresentableUrl());
                        }
                        if (f.isDirectory()) {
                            if (!lookForNested) return false;
                            f.refresh(false, false);
                            return true;
                        } else {
                            if (!MavenUtil.isPomFile(f)) return true;
                            result2.add(Pair.create((Object)f.getParent(), (Object)f));
                        }
                        return true;
                    }
                    catch (InvalidVirtualFileAccessException e) {
                        MavenLog.LOG.info((Throwable)e);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/utils/FileFinder$1", "visitFile"));
                }
            }, MavenProcessCanceledException.class);
        }
        Map pomFilesByParent = result2.stream().collect(Collectors.groupingBy(p -> (VirtualFile)p.getFirst(), Collectors.mapping(p -> (VirtualFile)p.getSecond(), Collectors.toList())));
        return pomFilesByParent.entrySet().stream().flatMap(pomsByParent -> FileFinder.getOriginalPoms((List)pomsByParent.getValue()).stream()).collect(Collectors.toList());
    }

    private static List<VirtualFile> getOriginalPoms(@NotNull List<VirtualFile> pomFiles) {
        if (pomFiles == null) {
            FileFinder.$$$reportNull$$$0(1);
        }
        if (pomFiles.size() < 2) {
            return pomFiles;
        }
        ArrayList<VirtualFile> originalPoms = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : pomFiles) {
            if (file2.getName().equals("pom.xml")) {
                return Collections.singletonList(file2);
            }
            if (!MavenUtil.isPomFileName(file2.getName())) continue;
            originalPoms.add(file2);
        }
        return originalPoms.isEmpty() ? pomFiles : originalPoms;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomFiles";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/FileFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findPomFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalPoms";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

