/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.TransportRequest;

@PublicApi(since="1.0.0")
public interface TransportChannel {
    public static final Logger logger = LogManager.getLogger(TransportChannel.class);

    public String getProfileName();

    public String getChannelType();

    public void sendResponse(TransportResponse var1) throws IOException;

    public void sendResponse(Exception var1) throws IOException;

    default public Version getVersion() {
        return Version.CURRENT;
    }

    public static void sendErrorResponse(TransportChannel channel, String actionName, TransportRequest request, Exception e) {
        try {
            channel.sendResponse(e);
        }
        catch (Exception sendException) {
            sendException.addSuppressed(e);
            logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)actionName, (Object)request), (Throwable)sendException);
        }
    }

    default public <T> Optional<T> get(String name, Class<T> clazz) {
        return Optional.empty();
    }
}

