/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;

final class NoneSignatureAlgorithm
implements SecureDigestAlgorithm<Key, Key> {
    private static final String ID = "none";
    static final SecureDigestAlgorithm<Key, Key> INSTANCE = new NoneSignatureAlgorithm();

    private NoneSignatureAlgorithm() {
    }

    public String getId() {
        return ID;
    }

    public byte[] digest(SecureRequest<InputStream, Key> request) throws SecurityException {
        throw new SignatureException("The 'none' algorithm cannot be used to create signatures.");
    }

    public boolean verify(VerifySecureDigestRequest<Key> request) throws SignatureException {
        throw new SignatureException("The 'none' algorithm cannot be used to verify signatures.");
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SecureDigestAlgorithm && ID.equalsIgnoreCase(((SecureDigestAlgorithm)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return ID;
    }
}

