/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.journal;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.cleric.PowerOfMany;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.SpiritHawk;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.ShadowClone;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.SmokeBomb;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Acidic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Albino;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.ArmoredBrute;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.ArmoredStatue;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bandit;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bat;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bee;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Brute;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CausticSlime;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Crab;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CrystalGuardian;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CrystalMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CrystalSpire;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CrystalWisp;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM100;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM200;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM201;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM300;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DemonSpawner;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DwarfKing;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.EbonyMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Elemental;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Eye;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.FetidRat;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Ghoul;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Gnoll;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GnollGeomancer;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GnollGuard;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GnollSapper;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GnollTrickster;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GoldenMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Golem;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Goo;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GreatCrab;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Guard;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Monk;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Necromancer;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.PhantomPiranha;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Piranha;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Pylon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Rat;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RipperDemon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotHeart;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotLasher;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Scorpio;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Senior;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Shaman;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Skeleton;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Slime;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Snake;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.SpectralNecromancer;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Spinner;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Statue;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Succubus;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Swarm;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Tengu;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Thief;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.TormentedSpirit;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Warlock;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Wraith;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.YogDzewa;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.YogFist;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Blacksmith;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Ghost;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Imp;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.MirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.PrismaticImage;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.RatKing;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Sheep;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Wandmaker;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CorpseDust;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLivingEarth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfRegrowth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfWarding;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SentryRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.AlarmTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BlazingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BurningTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ChillingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ConfusionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.CorrosionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.CursingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DisarmingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DisintegrationTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DistortionTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ExplosiveTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FlashingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FlockTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FrostTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GatewayTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GeyserTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GnollRockfallTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GrimTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GrippingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GuardianTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.OozeTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.PitfallTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.PoisonDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.RockfallTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ShockingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.StormTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.SummoningTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.TeleportationTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.TenguDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ToxicTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WarpingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WeakeningTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WornDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.BlandfruitBush;
import com.shatteredpixel.shatteredpixeldungeon.plants.Blindweed;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.plants.Fadeleaf;
import com.shatteredpixel.shatteredpixeldungeon.plants.Firebloom;
import com.shatteredpixel.shatteredpixeldungeon.plants.Icecap;
import com.shatteredpixel.shatteredpixeldungeon.plants.Mageroyal;
import com.shatteredpixel.shatteredpixeldungeon.plants.Rotberry;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sorrowmoss;
import com.shatteredpixel.shatteredpixeldungeon.plants.Starflower;
import com.shatteredpixel.shatteredpixeldungeon.plants.Stormvine;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sungrass;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.watabou.utils.Bundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public enum Bestiary {
    REGIONAL,
    BOSSES,
    UNIVERSAL,
    RARE,
    QUEST,
    NEUTRAL,
    ALLY,
    TRAP,
    PLANT;

    private final LinkedHashMap<Class<?>, Boolean> seen = new LinkedHashMap();
    private final LinkedHashMap<Class<?>, Integer> encounterCount = new LinkedHashMap();
    private static final HashMap<Class<?>, Class<?>> classConversions;
    public static boolean skipCountingEncounters;
    private static final String BESTIARY_CLASSES = "bestiary_classes";
    private static final String BESTIARY_SEEN = "bestiary_seen";
    private static final String BESTIARY_ENCOUNTERS = "bestiary_encounters";

    private void addEntities(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.seen.put(cls, false);
            this.encounterCount.put(cls, 0);
        }
    }

    public Collection<Class<?>> entities() {
        return this.seen.keySet();
    }

    public String title() {
        return Messages.get((Object)this, this.name() + ".title", new Object[0]);
    }

    public int totalEntities() {
        return this.seen.size();
    }

    public int totalSeen() {
        int seenTotal = 0;
        for (boolean entitySeen : this.seen.values()) {
            if (!entitySeen) continue;
            ++seenTotal;
        }
        return seenTotal;
    }

    public static boolean isSeen(Class<?> cls) {
        for (Bestiary cat : Bestiary.values()) {
            if (!cat.seen.containsKey(cls)) continue;
            return cat.seen.get(cls);
        }
        return false;
    }

    public static void setSeen(Class<?> cls) {
        if (classConversions.containsKey(cls)) {
            cls = classConversions.get(cls);
        }
        for (Bestiary cat : Bestiary.values()) {
            if (!cat.seen.containsKey(cls) || cat.seen.get(cls).booleanValue()) continue;
            cat.seen.put(cls, true);
            Journal.saveNeeded = true;
        }
        Badges.validateCatalogBadges();
    }

    public static int encounterCount(Class<?> cls) {
        for (Bestiary cat : Bestiary.values()) {
            if (!cat.encounterCount.containsKey(cls)) continue;
            return cat.encounterCount.get(cls);
        }
        return 0;
    }

    public static void countEncounter(Class<?> cls) {
        Bestiary.countEncounters(cls, 1);
    }

    public static void countEncounters(Class<?> cls, int encounters) {
        if (skipCountingEncounters) {
            return;
        }
        if (classConversions.containsKey(cls)) {
            cls = classConversions.get(cls);
        }
        for (Bestiary cat : Bestiary.values()) {
            if (!cat.encounterCount.containsKey(cls) || cat.encounterCount.get(cls) == Integer.MAX_VALUE) continue;
            cat.encounterCount.put(cls, cat.encounterCount.get(cls) + encounters);
            if (cat.encounterCount.get(cls) < -1000000000) {
                cat.encounterCount.put(cls, Integer.MAX_VALUE);
            }
            Journal.saveNeeded = true;
        }
    }

    public static void store(Bundle bundle) {
        ArrayList classes = new ArrayList();
        ArrayList<Boolean> seen = new ArrayList<Boolean>();
        ArrayList<Integer> encounters = new ArrayList<Integer>();
        for (Bestiary cat : Bestiary.values()) {
            for (Class<?> entity : cat.entities()) {
                if (!cat.seen.get(entity).booleanValue() && cat.encounterCount.get(entity) <= 0) continue;
                classes.add(entity);
                seen.add(cat.seen.get(entity));
                encounters.add(cat.encounterCount.get(entity));
            }
        }
        Class[] storeCls = new Class[classes.size()];
        boolean[] storeSeen = new boolean[seen.size()];
        int[] storeEncounters = new int[encounters.size()];
        for (int i = 0; i < storeCls.length; ++i) {
            storeCls[i] = (Class)classes.get(i);
            storeSeen[i] = (Boolean)seen.get(i);
            storeEncounters[i] = (Integer)encounters.get(i);
        }
        bundle.put(BESTIARY_CLASSES, storeCls);
        bundle.put(BESTIARY_SEEN, storeSeen);
        bundle.put(BESTIARY_ENCOUNTERS, storeEncounters);
    }

    public static void restore(Bundle bundle) {
        if (bundle.contains(BESTIARY_CLASSES) && bundle.contains(BESTIARY_SEEN) && bundle.contains(BESTIARY_ENCOUNTERS)) {
            Class[] classes = bundle.getClassArray(BESTIARY_CLASSES);
            boolean[] seen = bundle.getBooleanArray(BESTIARY_SEEN);
            int[] encounters = bundle.getIntArray(BESTIARY_ENCOUNTERS);
            for (int i = 0; i < classes.length; ++i) {
                for (Bestiary cat : Bestiary.values()) {
                    if (!cat.seen.containsKey(classes[i])) continue;
                    cat.seen.put(classes[i], seen[i]);
                    cat.encounterCount.put(classes[i], encounters[i]);
                }
            }
        }
    }

    static {
        REGIONAL.addEntities(Rat.class, Snake.class, Gnoll.class, Swarm.class, Crab.class, Slime.class, Skeleton.class, Thief.class, DM100.class, Guard.class, Necromancer.class, Bat.class, Brute.class, Shaman.RedShaman.class, Shaman.BlueShaman.class, Shaman.PurpleShaman.class, Spinner.class, DM200.class, Ghoul.class, Elemental.FireElemental.class, Elemental.FrostElemental.class, Elemental.ShockElemental.class, Warlock.class, Monk.class, Golem.class, RipperDemon.class, DemonSpawner.class, Succubus.class, Eye.class, Scorpio.class);
        BOSSES.addEntities(Goo.class, Tengu.class, Pylon.class, DM300.class, DwarfKing.class, YogDzewa.Larva.class, YogFist.BurningFist.class, YogFist.SoiledFist.class, YogFist.RottingFist.class, YogFist.RustedFist.class, YogFist.BrightFist.class, YogFist.DarkFist.class, YogDzewa.class);
        UNIVERSAL.addEntities(Wraith.class, Piranha.class, Mimic.class, GoldenMimic.class, EbonyMimic.class, Statue.class, GuardianTrap.Guardian.class, SentryRoom.Sentry.class);
        RARE.addEntities(Albino.class, CausticSlime.class, Bandit.class, SpectralNecromancer.class, ArmoredBrute.class, DM201.class, Elemental.ChaosElemental.class, Senior.class, Acidic.class, TormentedSpirit.class, PhantomPiranha.class, CrystalMimic.class, ArmoredStatue.class);
        QUEST.addEntities(FetidRat.class, GnollTrickster.class, GreatCrab.class, Elemental.NewbornFireElemental.class, RotLasher.class, RotHeart.class, CrystalWisp.class, CrystalGuardian.class, CrystalSpire.class, GnollGuard.class, GnollSapper.class, GnollGeomancer.class);
        NEUTRAL.addEntities(Ghost.class, RatKing.class, Shopkeeper.class, Wandmaker.class, Blacksmith.class, Imp.class, Sheep.class, Bee.class);
        ALLY.addEntities(MirrorImage.class, PrismaticImage.class, DriedRose.GhostHero.class, WandOfWarding.Ward.class, WandOfWarding.Ward.WardSentry.class, WandOfLivingEarth.EarthGuardian.class, ShadowClone.ShadowAlly.class, SmokeBomb.NinjaLog.class, SpiritHawk.HawkAlly.class, PowerOfMany.LightAlly.class);
        TRAP.addEntities(WornDartTrap.class, PoisonDartTrap.class, DisintegrationTrap.class, GatewayTrap.class, ChillingTrap.class, BurningTrap.class, ShockingTrap.class, AlarmTrap.class, GrippingTrap.class, TeleportationTrap.class, OozeTrap.class, FrostTrap.class, BlazingTrap.class, StormTrap.class, GuardianTrap.class, FlashingTrap.class, WarpingTrap.class, ConfusionTrap.class, ToxicTrap.class, CorrosionTrap.class, FlockTrap.class, SummoningTrap.class, WeakeningTrap.class, CursingTrap.class, GeyserTrap.class, ExplosiveTrap.class, RockfallTrap.class, PitfallTrap.class, DistortionTrap.class, DisarmingTrap.class, GrimTrap.class);
        PLANT.addEntities(Rotberry.class, Sungrass.class, Fadeleaf.class, Icecap.class, Firebloom.class, Sorrowmoss.class, Swiftthistle.class, Blindweed.class, Stormvine.class, Earthroot.class, Mageroyal.class, Starflower.class, BlandfruitBush.class, WandOfRegrowth.Dewcatcher.class, WandOfRegrowth.Seedpod.class, WandOfRegrowth.Lotus.class);
        classConversions = new HashMap();
        classConversions.put(CorpseDust.DustWraith.class, Wraith.class);
        classConversions.put(Necromancer.NecroSkeleton.class, Skeleton.class);
        classConversions.put(TenguDartTrap.class, PoisonDartTrap.class);
        classConversions.put(GnollRockfallTrap.class, RockfallTrap.class);
        classConversions.put(DwarfKing.DKGhoul.class, Ghoul.class);
        classConversions.put(DwarfKing.DKWarlock.class, Warlock.class);
        classConversions.put(DwarfKing.DKMonk.class, Monk.class);
        classConversions.put(DwarfKing.DKGolem.class, Golem.class);
        classConversions.put(YogDzewa.YogRipper.class, RipperDemon.class);
        classConversions.put(YogDzewa.YogEye.class, Eye.class);
        classConversions.put(YogDzewa.YogScorpio.class, Scorpio.class);
        skipCountingEncounters = false;
    }
}

