/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class MarkerAnnotation
extends SimpleMarkerAnnotation
implements IQuickFixableAnnotation {
    @Deprecated
    public static final int PROBLEM_LAYER = 5;
    private static Map<ImageDescriptor, Image> fgImageRegistry;
    private Image fImage;
    private String fImageName;
    private int fPresentationLayer = -1;
    private boolean fIsQuickFixable;
    private boolean fIsQuickFixableStateSet;

    @Deprecated
    protected static Image getImage(Display display, ImageDescriptor descriptor) {
        Map<ImageDescriptor, Image> map = MarkerAnnotation.getImageRegistry(display);
        Image image = map.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            map.put(descriptor, image);
        }
        return image;
    }

    @Deprecated
    protected static Map<ImageDescriptor, Image> getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new HashMap<ImageDescriptor, Image>();
            display.disposeExec(() -> {
                if (fgImageRegistry != null) {
                    Map<ImageDescriptor, Image> map = fgImageRegistry;
                    fgImageRegistry = null;
                    for (Image image : map.values()) {
                        if (image.isDisposed()) continue;
                        image.dispose();
                    }
                }
            });
        }
        return fgImageRegistry;
    }

    public MarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public MarkerAnnotation(String annotationType, IMarker marker) {
        super(annotationType, marker);
        this.initialize();
    }

    @Deprecated
    protected void setImage(Image image) {
        this.fImage = image;
    }

    @Deprecated
    protected void initialize() {
        IMarker marker = this.getMarker();
        String name = this.getUnknownImageName(marker);
        if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            name = "IMG_OBJS_TASK_TSK";
        } else if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.bookmark")) {
            name = "IMG_OBJS_BKMRK_TSK";
        } else if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtilities.getSeverity(marker)) {
                case 0: {
                    name = "IMG_OBJS_INFO_TSK";
                    break;
                }
                case 1: {
                    name = "IMG_OBJS_WARN_TSK";
                    break;
                }
                case 2: {
                    name = "IMG_OBJS_ERROR_TSK";
                }
            }
        }
        this.fImage = null;
        this.fImageName = name;
    }

    @Deprecated
    public int getLayer() {
        if (this.fPresentationLayer != -1) {
            return this.fPresentationLayer;
        }
        AnnotationPreference preference = EditorsPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(this);
        if (preference != null) {
            return preference.getPresentationLayer();
        }
        return 0;
    }

    @Deprecated
    protected void setLayer(int layer) {
        this.fPresentationLayer = layer;
    }

    @Deprecated
    public void paint(GC gc, Canvas canvas, Rectangle r) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    @Override
    public void update() {
        super.update();
        this.initialize();
    }

    @Deprecated
    protected String getUnknownImageName(IMarker marker) {
        return null;
    }

    @Deprecated
    protected Image getImage(String name) {
        if (name != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(name);
        }
        return null;
    }

    @Deprecated
    protected Image getImage(Display display) {
        if (this.fImage == null) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter adapter;
            IMarker marker = this.getMarker();
            if (marker.exists() && (adapter = (IWorkbenchAdapter)marker.getAdapter(IWorkbenchAdapter.class)) != null && (descriptor = adapter.getImageDescriptor((Object)marker)) != null) {
                this.fImage = MarkerAnnotation.getImage(display, descriptor);
            }
            if (this.fImage == null) {
                this.fImage = this.getImage(this.fImageName);
            }
        }
        return this.fImage;
    }

    public void setQuickFixable(boolean state) {
        this.fIsQuickFixable = state;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        Assert.isTrue((boolean)this.isQuickFixableStateSet());
        return this.fIsQuickFixable;
    }
}

