/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.ClassLoaderObjectInputStream;
import org.gradle.internal.serialize.ExceptionPlaceholder;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;

public class ExceptionReplacingObjectInputStream
extends ClassLoaderObjectInputStream {
    private Function<Object, Object> objectTransformer = o -> {
        try {
            return this.doResolveObject(o);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    };

    public ExceptionReplacingObjectInputStream(InputStream inputSteam, ClassLoader classLoader) throws IOException {
        super(inputSteam, classLoader);
        this.enableResolveObject(true);
    }

    public final Function<InputStream, ExceptionReplacingObjectInputStream> getObjectInputStreamCreator() {
        return inputStream -> {
            try {
                return this.createNewInstance((InputStream)inputStream);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        };
    }

    protected ExceptionReplacingObjectInputStream createNewInstance(InputStream inputStream) throws IOException {
        return new ExceptionReplacingObjectInputStream(inputStream, this.getClassLoader());
    }

    @Override
    protected final Object resolveObject(Object obj) throws IOException {
        return this.getObjectTransformer().apply(obj);
    }

    protected Object doResolveObject(Object obj) throws IOException {
        if (obj instanceof TopLevelExceptionPlaceholder) {
            return ((ExceptionPlaceholder)obj).read(this.getClassNameTransformer(), this.getObjectInputStreamCreator());
        }
        return obj;
    }

    protected final Function<String, Class<?>> getClassNameTransformer() {
        return type -> {
            try {
                return this.lookupClass((String)type);
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        };
    }

    protected Class<?> lookupClass(String type) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(type);
    }

    public Function<Object, Object> getObjectTransformer() {
        return this.objectTransformer;
    }

    public void setObjectTransformer(Function<Object, Object> objectTransformer) {
        this.objectTransformer = objectTransformer;
    }
}

