/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.InterfaceTypeImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;

public class ClassTypeImpl
extends ReferenceTypeImpl {
    private SoftReference<List<InterfaceTypeImpl>> interfacesCache = null;

    ClassTypeImpl(VirtualMachineImpl aVm, InstanceKlass aRef) {
        super(aVm, (Klass)aRef);
    }

    @Override
    public byte tag() {
        return 1;
    }

    public ClassTypeImpl superclass() {
        InstanceKlass kk = (InstanceKlass)this.ref().getSuper();
        if (kk == null) {
            return null;
        }
        return (ClassTypeImpl)this.vm.referenceType((Klass)kk);
    }

    public List<InterfaceTypeImpl> interfaces() {
        List<InterfaceTypeImpl> interfaces;
        List<InterfaceTypeImpl> list = interfaces = this.interfacesCache != null ? this.interfacesCache.get() : null;
        if (interfaces == null) {
            this.checkPrepared();
            interfaces = Collections.unmodifiableList(this.getInterfaces());
            this.interfacesCache = new SoftReference<List<InterfaceTypeImpl>>(interfaces);
        }
        return interfaces;
    }

    @Override
    boolean isAssignableTo(ReferenceTypeImpl type) {
        if (this.equals(type)) {
            return true;
        }
        ClassTypeImpl superclazz = this.superclass();
        if (superclazz != null && superclazz.isAssignableTo(type)) {
            return true;
        }
        List<InterfaceTypeImpl> interfaces = this.interfaces();
        for (InterfaceTypeImpl anInterface : interfaces) {
            if (!anInterface.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "class " + this.name() + "(" + this.loaderString() + ")";
    }
}

