/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.NsBinding;

public final class NsDeclaration {
    private final NsBinding mBinding;
    private final String mPreviousURI;
    private final NsDeclaration mPrevDeclaration;
    private final int mLevel;

    public NsDeclaration(NsBinding binding, String newURI, NsDeclaration prevDecl, int level) {
        this.mBinding = binding;
        this.mPrevDeclaration = prevDecl;
        this.mLevel = level;
        this.mPreviousURI = binding.mURI;
        binding.mURI = newURI;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public NsDeclaration getPrev() {
        return this.mPrevDeclaration;
    }

    public NsBinding getBinding() {
        return this.mBinding;
    }

    public String getPrefix() {
        return this.mBinding.mPrefix;
    }

    public String getCurrNsURI() {
        return this.mBinding.mURI;
    }

    public boolean hasPrefix(String prefix) {
        return prefix.equals(this.mBinding.mPrefix);
    }

    public boolean hasNsURI(String uri) {
        return uri.equals(this.mBinding.mURI);
    }

    public NsDeclaration unbind() {
        this.mBinding.mURI = this.mPreviousURI;
        return this.mPrevDeclaration;
    }

    public boolean alreadyDeclared(String prefix, int level) {
        if (this.mLevel >= level) {
            if (prefix == this.mBinding.mPrefix) {
                return true;
            }
            NsDeclaration prev = this.mPrevDeclaration;
            while (prev != null && prev.mLevel >= level) {
                if (prefix == prev.mBinding.mPrefix) {
                    return true;
                }
                prev = prev.mPrevDeclaration;
            }
        }
        return false;
    }

    public int countDeclsOnLevel(int level) {
        int count2 = 0;
        if (this.mLevel == level) {
            ++count2;
            NsDeclaration prev = this.mPrevDeclaration;
            while (prev != null && prev.mLevel == level) {
                ++count2;
                prev = prev.mPrevDeclaration;
            }
        }
        return count2;
    }

    public String toString() {
        return "[NS-DECL, prefix = <" + this.mBinding.mPrefix + ">, current URI <" + this.mBinding.mURI + ">, level " + this.mLevel + ", prev URI <" + this.mPreviousURI + ">]";
    }
}

