/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.execution.JUnitBundle;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExpectedExceptionNeverThrownInspection
extends BaseInspection {
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = JUnitBundle.message("expected.exception.never.thrown.problem.descriptor", method.getName());
        if (string == null) {
            ExpectedExceptionNeverThrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new ExpectedExceptionNeverThrownVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInspection/ExpectedExceptionNeverThrownInspection", "buildErrorString"));
    }

    private static class ExpectedExceptionNeverThrownVisitor
    extends BaseInspectionVisitor {
        private ExpectedExceptionNeverThrownVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ExpectedExceptionNeverThrownVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.junit.Test"});
            if (annotation == null) {
                return;
            }
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiAnnotationMemberValue value = null;
            for (PsiNameValuePair attribute : attributes) {
                if (!"expected".equals(attribute.getName())) continue;
                value = attribute.getValue();
                break;
            }
            if (!(value instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)value;
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType type = operand.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Error")) {
                return;
            }
            List exceptionsThrown = ExceptionUtil.getThrownExceptions((PsiElement)body);
            for (PsiClassType psiClassType : exceptionsThrown) {
                if (!psiClassType.isAssignableFrom(type)) continue;
                return;
            }
            this.registerError((PsiElement)operand, new Object[]{method});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/junit/codeInspection/ExpectedExceptionNeverThrownInspection$ExpectedExceptionNeverThrownVisitor", "visitMethod"));
        }
    }
}

