/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.converters.MavenProjectConstantListConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenPackagingConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenProjectConstantListConverter;", "<init>", "()V", "getValues", "", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Companion", "intellij.maven"})
public final class MavenPackagingConverter
extends MavenProjectConstantListConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> DEFAULT_PACKAGES;
    @NotNull
    private static final Set<String> MAVEN_4_SPECIFIC;

    public MavenPackagingConverter() {
        super(false);
    }

    @Override
    @NotNull
    protected Collection<String> getValues(@NotNull ConvertContext context2, @NotNull MavenProject project) {
        String modelVersion;
        DomFileElement model;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set result2 = new LinkedHashSet();
        result2.addAll((Collection)DEFAULT_PACKAGES);
        Iterator<MavenImporter> iterator = MavenImporter.getSuitableImporters(project).iterator();
        while (iterator.hasNext()) {
            MavenImporter each;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            each.getSupportedPackagings(result2);
        }
        XmlFile xmlFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile file2 = xmlFile;
        DomFileElement domFileElement = model = DomManager.getDomManager((Project)file2.getProject()).getFileElement(file2, MavenDomProjectModel.class);
        Object rootElement = domFileElement != null ? (GenericDomValue<String>)domFileElement.getRootElement() : null;
        Object object = rootElement;
        String string = object != null && (object = object.getModelVersion()) != null && (object = object.getStringValue()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : (modelVersion = null);
        if (!Intrinsics.areEqual(modelVersion, (Object)"4.0.0")) {
            result2.addAll((Collection)MAVEN_4_SPECIFIC);
        }
        return result2;
    }

    static {
        Object[] objectArray = new String[]{"pom", "jar", "ejb", "ejb-client", "war", "ear", "bundle", "maven-plugin"};
        DEFAULT_PACKAGES = SetsKt.setOf((Object[])objectArray);
        MAVEN_4_SPECIFIC = SetsKt.setOf((Object)"bom");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenPackagingConverter$Companion;", "", "<init>", "()V", "DEFAULT_PACKAGES", "", "", "getDEFAULT_PACKAGES", "()Ljava/util/Set;", "MAVEN_4_SPECIFIC", "getMAVEN_4_SPECIFIC", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getDEFAULT_PACKAGES() {
            return DEFAULT_PACKAGES;
        }

        @NotNull
        public final Set<String> getMAVEN_4_SPECIFIC() {
            return MAVEN_4_SPECIFIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

