/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.AbstractLauncher;
import com.jetbrains.jdi.ConnectorImpl;
import com.jetbrains.jdi.SharedMemoryAttachingConnector;
import com.jetbrains.jdi.SocketTransportService;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.connect.spi.TransportService;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

public class SunCommandLineLauncher
extends AbstractLauncher {
    private static final String ARG_HOME = "home";
    private static final String ARG_OPTIONS = "options";
    private static final String ARG_MAIN = "main";
    private static final String ARG_INIT_SUSPEND = "suspend";
    private static final String ARG_QUOTE = "quote";
    private static final String ARG_VM_EXEC = "vmexec";
    private static final String ARG_VM_INCLUDE_VTHREADS = "includevirtualthreads";
    TransportService transportService;
    Transport transport;
    boolean usingSharedMemory = false;

    TransportService transportService() {
        return this.transportService;
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    public SunCommandLineLauncher() {
        try {
            this.transportService = SharedMemoryAttachingConnector.createSharedMemoryTransportService();
            this.transport = () -> "dt_shmem";
            this.usingSharedMemory = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        if (this.transportService == null) {
            this.transportService = new SocketTransportService();
            this.transport = () -> "dt_socket";
        }
        this.addStringArgument(ARG_HOME, this.getString("sun.home.label"), this.getString("sun.home"), System.getProperty("java.home"), false);
        this.addStringArgument(ARG_OPTIONS, this.getString("sun.options.label"), this.getString("sun.options"), "", false);
        this.addStringArgument(ARG_MAIN, this.getString("sun.main.label"), this.getString("sun.main"), "", true);
        this.addBooleanArgument(ARG_INIT_SUSPEND, this.getString("sun.init_suspend.label"), this.getString("sun.init_suspend"), true, false);
        this.addStringArgument(ARG_QUOTE, this.getString("sun.quote.label"), this.getString("sun.quote"), "\"", true);
        this.addStringArgument(ARG_VM_EXEC, this.getString("sun.vm_exec.label"), this.getString("sun.vm_exec"), "java", true);
        this.addStringArgument(ARG_VM_INCLUDE_VTHREADS, this.getString("sun.include_virtualthreads.label"), this.getString("sun.include_virtualthreads"), "n", false);
    }

    static boolean hasWhitespace(String string2) {
        int length = string2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (!Character.isWhitespace(string2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachine vm;
        TransportService.ListenKey listenKey;
        String includeVThreads;
        String exe;
        String quote;
        boolean wait;
        String mainClassAndArgs;
        String options;
        String home;
        block11: {
            home = this.argument(ARG_HOME, arguments).value();
            options = this.argument(ARG_OPTIONS, arguments).value();
            mainClassAndArgs = this.argument(ARG_MAIN, arguments).value();
            wait = ((ConnectorImpl.BooleanArgumentImpl)this.argument(ARG_INIT_SUSPEND, arguments)).booleanValue();
            quote = this.argument(ARG_QUOTE, arguments).value();
            exe = this.argument(ARG_VM_EXEC, arguments).value();
            includeVThreads = this.argument(ARG_VM_INCLUDE_VTHREADS, arguments).value();
            if (quote.length() > 1) {
                throw new IllegalConnectorArgumentsException("Invalid length", ARG_QUOTE);
            }
            if (this.usingSharedMemory) {
                Random rr = new Random();
                int failCount = 0;
                while (true) {
                    try {
                        String address = "javadebug" + rr.nextInt(100000);
                        listenKey = this.transportService().startListening(address);
                        break block11;
                    }
                    catch (IOException ioe) {
                        if (++failCount <= 5) continue;
                        throw ioe;
                    }
                    break;
                }
            }
            listenKey = this.transportService().startListening();
        }
        String address = listenKey.address();
        try {
            Object exePath = home.length() > 0 ? home + File.separator + "bin" + File.separator + exe : exe;
            if (SunCommandLineLauncher.hasWhitespace((String)exePath)) {
                exePath = quote + (String)exePath + quote;
            }
            String xrun = "transport=" + this.transport().name() + ",address=" + address + ",suspend=" + (wait ? (char)'y' : 'n');
            if (!((Connector.Argument)this.defaultArguments.get(ARG_VM_INCLUDE_VTHREADS)).value().equals(includeVThreads)) {
                xrun = xrun + ",includevirtualthreads=" + includeVThreads;
            }
            if (SunCommandLineLauncher.hasWhitespace(xrun)) {
                xrun = quote + xrun + quote;
            }
            String command2 = (String)exePath + " " + options + " -Xrunjdwp:" + xrun + " " + mainClassAndArgs;
            vm = this.launch(this.tokenizeCommand(command2, quote.charAt(0)), address, listenKey, this.transportService());
        }
        finally {
            this.transportService().stopListening(listenKey);
        }
        return vm;
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.CommandLineLaunch");
    }

    @Override
    public String description() {
        return this.getString("sun.description");
    }
}

