/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ParameterCastFix;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.ApplicabilityResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ErasedArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0015J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\rH\u0004J\b\u0010!\u001a\u00020\u001eH\u0004J\b\u0010\"\u001a\u00020\u001eH\u0004J(\u0010#\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0002J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020'H\u0016J(\u0010)\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020*0%2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0014J\u0010\u0010+\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0014H\u0014J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020-0\u0016H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0019\u001a\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "getReference", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "getSink", "()Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "getInapplicableMethodMessage", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "containingType", "Lcom/intellij/psi/PsiType;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "highlightCannotApplyError", "", "invokedText", "typesString", "highlightUnknownArgs", "highlightAmbiguousMethod", "highlightInapplicableMethod", "results", "", "shouldHighlightInapplicable", "", "highlightMethodApplicability", "highlightClosureInvocation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "highlightApplicable", "buildCastFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "buildCastFix", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ExpressionArgument;", "expectedType", "buildFixes", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nCallReferenceHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallReferenceHighlighter.kt\norg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,179:1\n808#2,11:180\n774#2:191\n865#2,2:192\n1617#2,9:194\n1869#2:203\n1870#2:205\n1626#2:206\n1563#2:207\n1634#2,3:208\n1563#2:211\n1634#2,3:212\n1617#2,9:215\n1869#2:224\n1870#2:226\n1626#2:227\n1761#2,3:228\n1374#2:231\n1460#2,5:232\n808#2,11:244\n1617#2,9:255\n1869#2:264\n1870#2:266\n1626#2:267\n1#3:204\n1#3:225\n1#3:265\n536#4:237\n521#4,6:238\n*S KotlinDebug\n*F\n+ 1 CallReferenceHighlighter.kt\norg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter\n*L\n87#1:180,11\n88#1:191\n88#1:192,2\n95#1:194,9\n95#1:203\n95#1:205\n95#1:206\n101#1:207\n101#1:208,3\n111#1:211\n111#1:212,3\n114#1:215,9\n114#1:224\n114#1:226\n114#1:227\n121#1:228,3\n145#1:231\n145#1:232,5\n161#1:244,11\n161#1:255,9\n161#1:264\n161#1:266\n161#1:267\n95#1:204\n114#1:225\n161#1:265\n152#1:237\n152#1:238,6\n*E\n"})
public abstract class CallReferenceHighlighter {
    @NotNull
    private final GroovyCallReference reference;
    @NotNull
    private final HighlightSink sink;

    public CallReferenceHighlighter(@NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.reference = reference;
        this.sink = sink;
    }

    @NotNull
    protected final GroovyCallReference getReference() {
        return this.reference;
    }

    @NotNull
    protected final HighlightSink getSink() {
        return this.sink;
    }

    @NotNull
    protected String getAmbiguousMethodMessage() {
        String string = GroovyBundle.message("method.call.is.ambiguous", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    protected String getInapplicableMethodMessage(@NotNull GroovyMethodResult result2, @NotNull PsiType containingType, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)containingType, (String)"containingType");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        String string = containingType.getInternalCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalCanonicalText(...)");
        String typeText = string;
        String argumentsString = HighlightingKt.argumentsString(arguments2);
        Object[] objectArray = new Object[]{result2.getElement().getName(), typeText, argumentsString};
        String string2 = GroovyBundle.message("cannot.apply.method1", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    protected abstract PsiElement getHighlightElement();

    protected final void highlightCannotApplyError(@NotNull String invokedText, @NotNull String typesString) {
        Intrinsics.checkNotNullParameter((Object)invokedText, (String)"invokedText");
        Intrinsics.checkNotNullParameter((Object)typesString, (String)"typesString");
        Object[] objectArray = new Object[]{invokedText, typesString};
        this.sink.registerError(this.getHighlightElement(), GroovyBundle.message("cannot.apply.method.or.closure", objectArray), new LocalQuickFix[0]);
    }

    protected final void highlightUnknownArgs() {
        this.sink.registerProblem(this.getHighlightElement(), ProblemHighlightType.WEAK_WARNING, GroovyBundle.message("cannot.infer.argument.types", new Object[0]), new LocalQuickFix[0]);
    }

    protected final void highlightAmbiguousMethod() {
        this.sink.registerError(this.getHighlightElement(), this.getAmbiguousMethodMessage(), new LocalQuickFix[0]);
    }

    private final void highlightInapplicableMethod(Collection<? extends GroovyMethodResult> results, List<? extends Argument> arguments2) {
        GroovyMethodResult groovyMethodResult = (GroovyMethodResult)CollectionsKt.firstOrNull((Iterable)results);
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        PsiMethod psiMethod = result2.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getElement(...)");
        PsiMethod method = psiMethod;
        PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        PsiElement highlightElement = this.getHighlightElement();
        if (!highlightElement.isPhysical()) {
            return;
        }
        String argumentsString = HighlightingKt.argumentsString(arguments2);
        if (containingClass == null) {
            this.highlightCannotApplyError(methodName, argumentsString);
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiClassType psiClassType = factory.createType(containingClass, result2.getSubstitutor());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
        PsiClassType containingType = psiClassType;
        Collection collection = CollectionsKt.plus((Collection)this.buildCastFixes(results), (Iterable)this.buildFixes());
        Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        LocalQuickFix[] fixes = (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
        String message = this.getInapplicableMethodMessage(result2, (PsiType)containingType, arguments2);
        this.sink.registerProblem(highlightElement, ProblemHighlightType.GENERIC_ERROR, message, Arrays.copyOf(fixes, fixes.length));
    }

    protected boolean shouldHighlightInapplicable() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean highlightMethodApplicability() {
        Iterable<ErasedArgument> iterable;
        void $this$mapTo$iv$iv;
        Object result2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            CallReferenceHighlighter $this$highlightMethodApplicability_u24lambda_u240 = this;
            boolean bl = false;
            $this$highlightMethodApplicability_u24lambda_u240.highlightUnknownArgs();
            return true;
        }
        List<Argument> userArguments = list;
        Collection<? extends GroovyResolveResult> collection = this.reference.resolve(false);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolve(...)");
        Collection<? extends GroovyResolveResult> results = collection;
        if (results.isEmpty()) {
            return false;
        }
        Iterable $this$highlightMethodApplicability_u24lambda_u240 = results;
        boolean $i$f$filterIsInstance = false;
        void var6_8 = $this$filterIsInstance$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GroovyMethodResult)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)collection2;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        Collection collection3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroovyMethodResult it = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            if (!(!it.isInvokedOnProperty())) continue;
            collection3.add(element$iv$iv);
        }
        List methodResults = (List)collection3;
        if (methodResults.isEmpty()) {
            return this.highlightClosureInvocation(results, userArguments);
        }
        Iterable $this$mapNotNull$iv = methodResults;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        Iterable $this$forEach$iv$iv$iv = iterable2;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object t = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            result2 = (GroovyMethodResult)t;
            boolean bl3 = false;
            Object object = result2.getCandidate();
            if (object != null && (object = object.getArgumentMapping()) != null) {
                Object mapping = object;
                boolean bl4 = false;
                PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
                pair = new Pair(result2, (Object)mapping.highlightingApplicabilities(psiSubstitutor));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resultApplicabilities = (List)destination$iv$iv;
        Iterable iterable3 = resultApplicabilities;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = iterable3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl6 = false;
            iterable.add(((ApplicabilityResult)pair.getSecond()).getApplicability());
        }
        Applicability applicability = Applicability.totalApplicability((List)destination$iv$iv2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicability), (String)"totalApplicability(...)");
        Applicability totalApplicability = applicability;
        switch (WhenMappings.$EnumSwitchMapping$0[totalApplicability.ordinal()]) {
            case 1: {
                void $this$mapNotNullTo$iv$iv;
                Iterable destination$iv$iv3;
                if (!this.shouldHighlightInapplicable()) {
                    return false;
                }
                GroovyMethodResult singleResult = (GroovyMethodResult)CollectionsKt.singleOrNull((List)methodResults);
                if (singleResult != null) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv = userArguments;
                    boolean $i$f$map2 = false;
                    Iterable $i$f$mapTo2 = $this$map$iv;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void p0;
                        result2 = (Argument)item$iv$iv;
                        iterable = destination$iv$iv3;
                        boolean bl7 = false;
                        iterable.add(new ErasedArgument((Argument)p0));
                    }
                    if (GroovyApplicabilityProvider.checkProviders((List)destination$iv$iv3, singleResult.getElement()) == Applicability.applicable) {
                        return false;
                    }
                }
                Iterable $this$mapNotNull$iv2 = resultApplicabilities;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv3 = $this$mapNotNull$iv2;
                Collection destination$iv$iv4 = new ArrayList();
                boolean bl8 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    GroovyMethodResult it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl9 = false;
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl10 = false;
                    GroovyMethodResult result3 = (GroovyMethodResult)pair.component1();
                    ApplicabilityResult applicabilityResult = (ApplicabilityResult)pair.component2();
                    if ((applicabilityResult.getApplicability() == Applicability.inapplicable ? result3 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl11 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                Collection inapplicableResults = (List)destination$iv$iv4;
                this.highlightInapplicableMethod(inapplicableResults, userArguments);
                return true;
            }
            case 2: {
                if (methodResults.size() != 1) {
                    Argument it;
                    Iterable $this$any$iv = userArguments;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator3 = $this$any$iv.iterator();
                    do {
                        if (!iterator3.hasNext()) return false;
                        Object element$iv = iterator3.next();
                        it = (Argument)element$iv;
                        boolean bl12 = false;
                    } while (!(it.getType() == null));
                    boolean bl13 = true;
                    if (!bl13) return false;
                }
                this.highlightUnknownArgs();
                return true;
            }
            case 3: {
                if (resultApplicabilities.size() <= 1) return this.highlightApplicable((GroovyMethodResult)((Pair)CollectionsKt.single((List)resultApplicabilities)).getFirst());
                this.highlightAmbiguousMethod();
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    protected boolean highlightClosureInvocation(@NotNull Collection<? extends GroovyResolveResult> results, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        return false;
    }

    protected boolean highlightApplicable(@NotNull GroovyMethodResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(Collection<? extends GroovyMethodResult> results) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = results;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GroovyMethodResult p0 = (GroovyMethodResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.buildCastFixes(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalQuickFix> buildCastFixes(GroovyMethodResult result2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterTo$iv$iv;
        ArgumentMapping<PsiCallParameter> argumentMapping;
        ArgumentMapping<PsiCallParameter> mapping;
        block9: {
            block8: {
                GroovyMethodCandidate groovyMethodCandidate = result2.getCandidate();
                if (groovyMethodCandidate == null) {
                    return CollectionsKt.emptyList();
                }
                GroovyMethodCandidate candidate = groovyMethodCandidate;
                ArgumentMapping<PsiCallParameter> argumentMapping2 = candidate.getArgumentMapping();
                if (argumentMapping2 == null) {
                    return CollectionsKt.emptyList();
                }
                mapping = argumentMapping2;
                argumentMapping = candidate.getArgumentMapping();
                if (argumentMapping == null) break block8;
                PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
                if ((argumentMapping = argumentMapping.highlightingApplicabilities(psiSubstitutor)) != null) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ArgumentMapping<PsiCallParameter> applicabilities = argumentMapping;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> $this$filter$iv = applicabilities.getArgumentApplicabilities();
        boolean $i$f$filter = false;
        Map<Argument, ApplicabilityResult.ArgumentApplicability> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            Map.Entry entry = element$iv$iv;
            boolean bl = false;
            ApplicabilityResult.ArgumentApplicability data = (ApplicabilityResult.ArgumentApplicability)entry.getValue();
            if (!(data.getApplicability() == Applicability.inapplicable)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set notApplicableArguments = destination$iv$iv.keySet();
        PsiElement psiElement = this.reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement callElement = psiElement;
        PsiSubstitutor substitutor = GroovyInferenceSessionBuilderKt.buildTopLevelSession$default(callElement, false, SetsKt.setOf(arg_0 -> CallReferenceHighlighter.buildCastFixes$lambda$1(notApplicableArguments, arg_0)), false, 8, null).inferSubst();
        Iterable $this$filterIsInstance$iv = notApplicableArguments;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$filterTo22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExpressionArgument)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LocalQuickFix it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ExpressionArgument argument = (ExpressionArgument)element$iv$iv;
            boolean bl2 = false;
            PsiType fixType = substitutor.substitute(mapping.expectedType(argument));
            if ((fixType != null ? this.buildCastFix(argument, fixType) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @Nullable
    protected LocalQuickFix buildCastFix(@NotNull ExpressionArgument argument, @NotNull PsiType expectedType) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        List<Argument> list = this.reference.getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        int position = arguments2.indexOf(argument);
        if (position < 0) {
            return null;
        }
        return (LocalQuickFix)new ParameterCastFix(argument.getExpression(), position, expectedType);
    }

    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        return CollectionsKt.emptyList();
    }

    private static final boolean buildCastFixes$lambda$1(Set $notApplicableArguments, GrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$notApplicableArguments.contains(new ExpressionArgument(it));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.inapplicable.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.canBeApplicable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.applicable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

