/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public final class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE;
    private static final int NEW_EXPR_PRECEDENCE;
    private static final int LITERAL_PRECEDENCE;
    public static final int METHOD_CALL_PRECEDENCE;
    private static final int POSTFIX_PRECEDENCE;
    public static final int PREFIX_PRECEDENCE;
    public static final int TYPE_CAST_PRECEDENCE;
    public static final int EXPONENTIAL_PRECEDENCE;
    public static final int MULTIPLICATIVE_PRECEDENCE;
    private static final int ADDITIVE_PRECEDENCE;
    private static final int SHIFT_PRECEDENCE;
    private static final int RANGE_PRECEDENCE;
    public static final int INSTANCEOF_PRECEDENCE;
    public static final int RELATIONAL_PRECEDENCE;
    public static final int EQUALITY_PRECEDENCE;
    private static final int BINARY_AND_PRECEDENCE;
    private static final int BINARY_XOR_PRECEDENCE;
    private static final int BINARY_OR_PRECEDENCE;
    public static final int AND_PRECEDENCE;
    public static final int OR_PRECEDENCE;
    public static final int IMPL_PRECEDENCE;
    public static final int CONDITIONAL_PRECEDENCE;
    public static final int SAFE_CAST_PRECEDENCE;
    private static final int ASSIGNMENT_PRECEDENCE;
    private static final int APPLICATION_STMT_PRECEDENCE;
    private static final Map<IElementType, Integer> BINARY_PRECEDENCES;

    private ParenthesesUtils() {
    }

    public static int precedenceForBinaryOperator(@NotNull IElementType sign) {
        Integer result2;
        if (sign == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        return (result2 = BINARY_PRECEDENCES.get(sign)) != null ? result2 : 0;
    }

    public static int getPrecedence(GrExpression expr) {
        if (expr instanceof GrUnaryExpression) {
            return ((GrUnaryExpression)expr).isPostfix() ? POSTFIX_PRECEDENCE : PREFIX_PRECEDENCE;
        }
        if (expr instanceof GrTypeCastExpression) {
            return TYPE_CAST_PRECEDENCE;
        }
        if (expr instanceof GrRangeExpression) {
            return RANGE_PRECEDENCE;
        }
        if (expr instanceof GrConditionalExpression) {
            return CONDITIONAL_PRECEDENCE;
        }
        if (expr instanceof GrSafeCastExpression) {
            return SAFE_CAST_PRECEDENCE;
        }
        if (expr instanceof GrAssignmentExpression) {
            return ASSIGNMENT_PRECEDENCE;
        }
        if (expr instanceof GrApplicationStatement) {
            return APPLICATION_STMT_PRECEDENCE;
        }
        if (expr instanceof GrInstanceOfExpression) {
            return INSTANCEOF_PRECEDENCE;
        }
        if (expr instanceof GrNewExpression) {
            return NEW_EXPR_PRECEDENCE;
        }
        if (expr instanceof GrParenthesizedExpression) {
            return PARENTHESIZED_PRECEDENCE;
        }
        if (expr instanceof GrReferenceExpression) {
            GrReferenceExpression referenceExpression = (GrReferenceExpression)expr;
            return referenceExpression.getQualifierExpression() == null ? LITERAL_PRECEDENCE : METHOD_CALL_PRECEDENCE;
        }
        if (expr instanceof GrBinaryExpression) {
            IElementType opToken = ((GrBinaryExpression)expr).getOperationTokenType();
            return ParenthesesUtils.precedenceForBinaryOperator(opToken);
        }
        return 0;
    }

    @NotNull
    public static GrExpression parenthesize(@NotNull GrExpression expression) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        return ParenthesesUtils.parenthesize(expression, null);
    }

    @NotNull
    public static GrExpression parenthesize(@NotNull GrExpression expression, @Nullable PsiElement context) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(2);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrParenthesizedExpression grParenthesizedExpression = factory.createParenthesizedExpr(expression, context);
        if (grParenthesizedExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(3);
        }
        return grParenthesizedExpression;
    }

    @NotNull
    public static GrExpression unparenthesize(@NotNull GrExpression expression) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(4);
        }
        GrExpression currentExpression = expression;
        while (currentExpression instanceof GrParenthesizedExpression) {
            GrExpression operand = ((GrParenthesizedExpression)currentExpression).getOperand();
            if (operand != null) {
                currentExpression = operand;
                continue;
            }
            GrExpression grExpression = currentExpression;
            if (grExpression == null) {
                ParenthesesUtils.$$$reportNull$$$0(5);
            }
            return grExpression;
        }
        GrExpression grExpression = currentExpression;
        if (grExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(6);
        }
        return grExpression;
    }

    public static boolean checkPrecedenceForBinaryOps(int childPrecedence, @NotNull IElementType parentToken, boolean isRhs) {
        int parentPrecedence;
        if (parentToken == null) {
            ParenthesesUtils.$$$reportNull$$$0(7);
        }
        return (parentPrecedence = ParenthesesUtils.precedenceForBinaryOperator(parentToken)) < childPrecedence || parentPrecedence == childPrecedence && parentPrecedence != 0 && isRhs;
    }

    public static boolean checkPrecedenceForNonBinaryOps(@NotNull GrExpression newExpr, int parentPrecedence) {
        if (newExpr == null) {
            ParenthesesUtils.$$$reportNull$$$0(8);
        }
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(ParenthesesUtils.getPrecedence(newExpr), parentPrecedence);
    }

    public static boolean checkPrecedenceForNonBinaryOps(int precedence, int parentPrecedence) {
        return ParenthesesUtils.checkPrecedence(precedence, parentPrecedence);
    }

    public static boolean checkPrecedence(int newPrecedence, int oldPrecedence) {
        return newPrecedence > oldPrecedence;
    }

    public static boolean checkPrecedence(int precedence, @NotNull GrExpression oldExpr) {
        PsiElement parent;
        if (oldExpr == null) {
            ParenthesesUtils.$$$reportNull$$$0(9);
        }
        if ((parent = oldExpr.getParent()) instanceof GrArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof GrExpression)) {
            return false;
        }
        GrExpression oldParent = (GrExpression)parent;
        if (oldParent instanceof GrBinaryExpression) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)oldParent;
            GrExpression rightOperand = binaryExpression.getRightOperand();
            return ParenthesesUtils.checkPrecedenceForBinaryOps(precedence, binaryExpression.getOperationTokenType(), oldExpr.equals(rightOperand));
        }
        return ParenthesesUtils.checkPrecedenceForNonBinaryOps(precedence, ParenthesesUtils.getPrecedence(oldParent));
    }

    public static boolean checkPrecedence(@NotNull GrExpression newExpr, @NotNull GrExpression oldExpr) {
        if (newExpr == null) {
            ParenthesesUtils.$$$reportNull$$$0(10);
        }
        if (oldExpr == null) {
            ParenthesesUtils.$$$reportNull$$$0(11);
        }
        return ParenthesesUtils.checkPrecedence(ParenthesesUtils.getPrecedence(newExpr), oldExpr);
    }

    static {
        int i2 = 0;
        PARENTHESIZED_PRECEDENCE = 0;
        LITERAL_PRECEDENCE = 0;
        NEW_EXPR_PRECEDENCE = 0;
        METHOD_CALL_PRECEDENCE = 0;
        TYPE_CAST_PRECEDENCE = i2++;
        POSTFIX_PRECEDENCE = i2++;
        EXPONENTIAL_PRECEDENCE = i2++;
        PREFIX_PRECEDENCE = i2++;
        MULTIPLICATIVE_PRECEDENCE = i2++;
        ADDITIVE_PRECEDENCE = i2++;
        SHIFT_PRECEDENCE = i2++;
        RANGE_PRECEDENCE = i2++;
        INSTANCEOF_PRECEDENCE = i2++;
        RELATIONAL_PRECEDENCE = i2++;
        EQUALITY_PRECEDENCE = i2++;
        BINARY_AND_PRECEDENCE = i2++;
        BINARY_XOR_PRECEDENCE = i2++;
        BINARY_OR_PRECEDENCE = i2++;
        AND_PRECEDENCE = i2++;
        OR_PRECEDENCE = i2++;
        IMPL_PRECEDENCE = i2++;
        CONDITIONAL_PRECEDENCE = i2++;
        SAFE_CAST_PRECEDENCE = i2++;
        ASSIGNMENT_PRECEDENCE = i2++;
        APPLICATION_STMT_PRECEDENCE = i2;
        BINARY_PRECEDENCES = new HashMap<IElementType, Integer>();
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mPLUS, ADDITIVE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mMINUS, ADDITIVE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mSTAR, MULTIPLICATIVE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mDIV, MULTIPLICATIVE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mMOD, MULTIPLICATIVE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mSTAR_STAR, EXPONENTIAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mLAND, AND_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mLOR, OR_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mIMPL, IMPL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mBAND, BINARY_AND_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mBOR, BINARY_OR_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mBXOR, BINARY_XOR_PRECEDENCE);
        BINARY_PRECEDENCES.put(org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, SHIFT_PRECEDENCE);
        BINARY_PRECEDENCES.put(org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, SHIFT_PRECEDENCE);
        BINARY_PRECEDENCES.put(org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, SHIFT_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mRANGE_INCLUSIVE, RANGE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mRANGE_EXCLUSIVE_LEFT, RANGE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mRANGE_EXCLUSIVE_RIGHT, RANGE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mRANGE_EXCLUSIVE_BOTH, RANGE_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mGT, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mGE, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mLT, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mLE, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mEQUAL, EQUALITY_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyElementTypes.KW_IN, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyElementTypes.T_NOT_IN, RELATIONAL_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mNOT_EQUAL, EQUALITY_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mCOMPARE_TO, EQUALITY_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.kAS, SAFE_CAST_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mREGEX_FIND, EQUALITY_PRECEDENCE);
        BINARY_PRECEDENCES.put(GroovyTokenTypes.mREGEX_MATCH, EQUALITY_PRECEDENCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/utils/ParenthesesUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToken";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/utils/ParenthesesUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parenthesize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unparenthesize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "precedenceForBinaryOperator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parenthesize";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unparenthesize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkPrecedenceForBinaryOps";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPrecedenceForNonBinaryOps";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkPrecedence";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

