/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.VcsLogAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.impl.RepositoryBrowser;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.i18n.GitBundle;
import git4idea.log.GitDirectoryVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\nH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Lgit4idea/log/GitBrowseRepoAtRevisionAction;", "Lcom/intellij/dvcs/ui/VcsLogAction;", "Lgit4idea/repo/GitRepository;", "<init>", "()V", "actionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "grouped", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "isEnabled", "", "Lcom/intellij/vcs/log/Hash;", "getRepositoryManager", "Lcom/intellij/dvcs/repo/AbstractRepositoryManager;", "getRepositoryForRoot", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
public final class GitBrowseRepoAtRevisionAction
extends VcsLogAction<GitRepository> {
    protected void actionPerformed(@NotNull Project project, @NotNull MultiMap<GitRepository, VcsFullCommitDetails> grouped) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grouped, (String)"grouped");
        Set set = grouped.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        GitRepository repo = (GitRepository)CollectionsKt.single((Iterable)set);
        Collection collection = grouped.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        VcsFullCommitDetails commit = (VcsFullCommitDetails)CollectionsKt.single((Iterable)collection);
        Intrinsics.checkNotNull((Object)repo);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)repo.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        Intrinsics.checkNotNull((Object)commit);
        GitDirectoryVirtualFile root = new GitDirectoryVirtualFile(repo, null, filePath, (VcsCommitMetadata)commit);
        AbstractVcsVirtualFile abstractVcsVirtualFile = root;
        VirtualFile virtualFile = repo.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Object[] objectArray = new Object[]{repo.getRoot().getName(), ((Hash)commit.getId()).toShortString()};
        String string = GitBundle.message("tab.title.repo.root.name.at.revision", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        RepositoryBrowser.INSTANCE.showRepositoryBrowser(project, abstractVcsVirtualFile, virtualFile, string);
    }

    protected boolean isEnabled(@NotNull MultiMap<GitRepository, Hash> grouped) {
        Intrinsics.checkNotNullParameter(grouped, (String)"grouped");
        return grouped.values().size() == 1;
    }

    @NotNull
    protected AbstractRepositoryManager<GitRepository> getRepositoryManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        return gitRepositoryManager;
    }

    @Nullable
    protected GitRepository getRepositoryForRoot(@NotNull Project project, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return (GitRepository)this.getRepositoryManager(project).getRepositoryForRootQuick(root);
    }
}

