/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryDirectory;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntryFile;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IgnoreDirectoryMarkerProvider
extends LineMarkerProviderDescriptor
implements DumbAware {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return;
        }
        HashSet<IgnoreFileRecord> ignoreEntryFiles = new HashSet<IgnoreFileRecord>(elements.size());
        ArrayList<IgnoreEntryDirectory> ignoreEntryDirectories = new ArrayList<IgnoreEntryDirectory>(elements.size());
        Project project = elements.get(0).getProject();
        PatternCache patternCache = PatternCache.getInstance(project);
        VirtualFile parent = elements.get(0).getContainingFile().getVirtualFile().getParent();
        VirtualFile projectDir = project.getBaseDir();
        boolean isRootFile = parent == null || projectDir == null;
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            if (!(psiElement instanceof IgnoreEntryFile)) continue;
            IgnoreEntryFile entry = (IgnoreEntryFile)psiElement;
            if (entry instanceof IgnoreEntryDirectory) {
                IgnoreEntryDirectory dir = (IgnoreEntryDirectory)entry;
                ignoreEntryDirectories.add(dir);
                continue;
            }
            Pattern pattern = patternCache.createPattern(entry);
            if (pattern == null || isRootFile) continue;
            ignoreEntryFiles.add(new IgnoreFileRecord(entry, pattern));
        }
        if (!ignoreEntryFiles.isEmpty()) {
            IgnoreDirectoryMarkerProvider.computerDirectoriesExist(parent, ignoreEntryFiles, ignoreEntryDirectories);
        }
        for (IgnoreEntryFile ignoreEntryFile : ignoreEntryDirectories) {
            ProgressManager.checkCanceled();
            PsiElement leafElement = IgnoreDirectoryMarkerProvider.firstLeafOrNull(ignoreEntryFile);
            if (leafElement == null) continue;
            result2.add(new LineMarkerInfo(leafElement, ignoreEntryFile.getTextRange(), PlatformIcons.FOLDER_ICON, null, null, GutterIconRenderer.Alignment.CENTER));
        }
    }

    @NotNull
    public String getName() {
        String string = VcsBundle.message((String)"gutter.name.version.control.ignored.directories", (Object[])new Object[0]);
        if (string == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformIcons.FOLDER_ICON;
        if (icon == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    private static PsiElement firstLeafOrNull(@NotNull PsiElement element) {
        LeafElement firstLeaf;
        if (element == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(5);
        }
        return (firstLeaf = TreeUtil.findFirstLeaf((ASTNode)element.getNode())) != null ? firstLeaf.getPsi() : null;
    }

    private static void computerDirectoriesExist(@NotNull VirtualFile root, @NotNull Collection<IgnoreFileRecord> fileRecords, @NotNull List<? super IgnoreEntryFile> ignoreEntryDirectories) {
        if (root == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(6);
        }
        if (fileRecords == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(7);
        }
        if (ignoreEntryDirectories == null) {
            IgnoreDirectoryMarkerProvider.$$$reportNull$$$0(8);
        }
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, file -> file.isDirectory(), dir -> {
            ProgressManager.checkCanceled();
            String path = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)root);
            if (path != null) {
                for (IgnoreFileRecord fileRecord : fileRecords) {
                    if (!RegexUtil.match(fileRecord.pattern, path)) continue;
                    fileRecords.remove(fileRecord);
                    ignoreEntryDirectories.add(fileRecord.entry());
                    if (!fileRecords.isEmpty()) break;
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRecords";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreEntryDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "firstLeafOrNull";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computerDirectoriesExist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private record IgnoreFileRecord(@NotNull IgnoreEntryFile entry, @NotNull Pattern pattern) {
        @NotNull
        private final IgnoreEntryFile entry;
        @NotNull
        private final Pattern pattern;

        private IgnoreFileRecord(@NotNull IgnoreEntryFile entry, @NotNull Pattern pattern) {
            if (entry == null) {
                IgnoreFileRecord.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                IgnoreFileRecord.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public IgnoreEntryFile entry() {
            IgnoreEntryFile ignoreEntryFile = this.entry;
            if (ignoreEntryFile == null) {
                IgnoreFileRecord.$$$reportNull$$$0(2);
            }
            return ignoreEntryFile;
        }

        @NotNull
        public Pattern pattern() {
            Pattern pattern = this.pattern;
            if (pattern == null) {
                IgnoreFileRecord.$$$reportNull$$$0(3);
            }
            return pattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider$IgnoreFileRecord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/codeInsight/IgnoreDirectoryMarkerProvider$IgnoreFileRecord";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "entry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

