/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.microsoft;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.UserAuthenticationIdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.microsoft.MicrosoftIdentityProviderConfig;

public class MicrosoftIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    private static final Logger log = Logger.getLogger(MicrosoftIdentityProvider.class);
    private static final String AUTH_URL_TEMPLATE = "https://login.microsoftonline.com/%s/oauth2/v2.0/authorize";
    private static final String TOKEN_URL_TEMPLATE = "https://login.microsoftonline.com/%s/oauth2/v2.0/token";
    private static final String PROFILE_URL = "https://graph.microsoft.com/v1.0/me/";
    private static final String DEFAULT_SCOPE = "User.read";

    public MicrosoftIdentityProvider(KeycloakSession session, MicrosoftIdentityProviderConfig config) {
        super(session, config);
        String tenant = Optional.ofNullable(config.getTenantId()).map(String::trim).orElse("common");
        config.setAuthorizationUrl(String.format(AUTH_URL_TEMPLATE, tenant));
        config.setTokenUrl(String.format(TOKEN_URL_TEMPLATE, tenant));
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return PROFILE_URL;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.create((KeycloakSession)this.session).doGet(PROFILE_URL).auth(accessToken).asJson();
            if (profile.has("error") && !profile.get("error").isNull()) {
                throw new IdentityBrokerException("Error in Microsoft Graph API response. Payload: " + profile.toString());
            }
            return this.extractIdentityFromProfile(null, profile);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from Microsoft Graph", (Throwable)e);
        }
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        String username;
        String id = this.getJsonProperty(profile, "id");
        BrokeredIdentityContext user = new BrokeredIdentityContext(id, this.getConfig());
        String email = this.getJsonProperty(profile, "mail");
        if (email == null && profile.has("userPrincipalName") && Validation.isEmailValid(username = this.getJsonProperty(profile, "userPrincipalName"))) {
            email = username;
        }
        user.setUsername(email != null ? email : id);
        user.setFirstName(this.getJsonProperty(profile, "givenName"));
        user.setLastName(this.getJsonProperty(profile, "surname"));
        if (email != null) {
            user.setEmail(email);
        }
        user.setIdp((UserAuthenticationIdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        return user;
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

