/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Map;
import org.hibernate.internal.util.collections.ReadOnlyMap;

public final class MapBackedClassValue<V>
implements ReadOnlyMap<Class<?>, V> {
    private volatile Map<Class<?>, V> map;
    private final ClassValue<V> classValue = new ClassValue<V>(){

        @Override
        protected V computeValue(Class<?> type) {
            Map m = MapBackedClassValue.this.map;
            if (m == null) {
                throw new IllegalStateException("This MapBackedClassValue has been disposed");
            }
            return MapBackedClassValue.this.map.get(type);
        }
    };

    public MapBackedClassValue(Map<Class<?>, V> map) {
        this.map = Map.copyOf(map);
    }

    @Override
    public V get(Class<?> key) {
        return this.classValue.get(key);
    }

    @Override
    public void dispose() {
        Map<Class<?>, V> existing = this.map;
        this.map = null;
        if (existing != null) {
            for (Map.Entry<Class<?>, V> entry : existing.entrySet()) {
                this.classValue.remove(entry.getKey());
            }
        }
    }
}

