/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.stat;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.stat.BaseMetricInfo;

public final class TimeGaugeMetricInfo<T>
extends BaseMetricInfo {
    private final Function<T, Number> function;
    private final TimeUnit timeUnit;

    public TimeGaugeMetricInfo(String name, String description, Map<String, String> map, Function<T, Number> function, TimeUnit timeUnit) {
        super(name, description, map);
        this.function = Objects.requireNonNull(function);
        this.timeUnit = Objects.requireNonNull(timeUnit);
    }

    public Supplier<Number> getGauge(T instance) {
        return () -> this.function.apply(instance);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public String getType() {
        return "time gauge";
    }
}

