/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.stream.ValueIdentityBiFunction;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;

@ProtoTypeId(value=65620)
public class LoginFailuresLifespanUpdate
implements BiConsumer<Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>, Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>> {
    @ProtoField(value=1)
    final long maxDeltaTimeMillis;
    @ProtoField(value=2)
    final int maxTemporaryLockouts;
    @ProtoField(value=3)
    final boolean permanentLockout;

    @ProtoFactory
    public LoginFailuresLifespanUpdate(long maxDeltaTimeMillis, int maxTemporaryLockouts, boolean permanentLockout) {
        this.maxDeltaTimeMillis = maxDeltaTimeMillis;
        this.maxTemporaryLockouts = maxTemporaryLockouts;
        this.permanentLockout = permanentLockout;
    }

    @Override
    public void accept(Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> cache, Map.Entry<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> entry) {
        LoginFailureEntity entity = entry.getValue().getEntity();
        long lifespan = SessionTimeouts.getLoginFailuresLifespanMs(this.permanentLockout, this.maxTemporaryLockouts, this.maxDeltaTimeMillis, entity);
        cache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY, Flag.IGNORE_RETURN_VALUES}).computeIfPresent((Object)entry.getKey(), ValueIdentityBiFunction.getInstance(), lifespan, TimeUnit.MILLISECONDS);
    }
}

