/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.jpa.session.JpaUserSessionPersisterProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.session.UserSessionPersisterProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class JpaUserSessionPersisterProviderFactory
implements UserSessionPersisterProviderFactory,
ServerInfoAwareProviderFactory {
    public static final String ID = "jpa";
    private static final String EXPIRATION_BATCH_CONFIG = "expirationBatch";
    public static final int DEFAULT_EXPIRATION_BATCH = 512;
    private int expirationBatch = 512;

    public UserSessionPersisterProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaUserSessionPersisterProvider(session, em, this.expirationBatch);
    }

    public void init(Config.Scope config) {
        this.expirationBatch = Math.max(1, config.getInt(EXPIRATION_BATCH_CONFIG, Integer.valueOf(512)));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public int order() {
        return 100;
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(JpaConnectionProvider.class);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(EXPIRATION_BATCH_CONFIG).helpText("Sets the size of the expiration batch, i.e., the number of expired sessions to remove per delete statement.").label("size").type("Integer").defaultValue((Object)512).add();
        return builder.build();
    }

    public Map<String, String> getOperationalInfo() {
        return Map.of(EXPIRATION_BATCH_CONFIG, Integer.toString(this.expirationBatch));
    }
}

