/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import org.opensearch.geospatial.h3.LatLng;

final class Vec3d {
    public static final double[][] faceCenterPoint = new double[][]{{0.2199307791404606, 0.6583691780274996, 0.7198475378926182}, {-0.2139234834501421, 0.1478171829550703, 0.9656017935214205}, {0.1092625278784797, -0.481195157287321, 0.8697775121287253}, {0.7428567301586791, -0.3593941678278028, 0.5648005936517033}, {0.8112534709140969, 0.3448953237639384, 0.472138773641393}, {-0.1055498149613921, 0.9794457296411413, 0.1718874610009365}, {-0.8075407579970092, 0.1533552485898818, 0.5695261994882688}, {-0.2846148069787907, -0.8644080972654206, 0.4144792552473539}, {0.7405621473854482, -0.6673299564565524, -0.0789837646326737}, {0.8512303986474293, 0.4722343788582681, -0.2289137388687808}, {-0.7405621473854481, 0.6673299564565524, 0.0789837646326737}, {-0.8512303986474292, -0.4722343788582682, 0.2289137388687808}, {0.1055498149613919, -0.9794457296411413, -0.1718874610009365}, {0.8075407579970092, -0.1533552485898819, -0.5695261994882688}, {0.2846148069787908, 0.8644080972654204, -0.4144792552473539}, {-0.7428567301586791, 0.3593941678278027, -0.5648005936517033}, {-0.811253470914097, -0.3448953237639382, -0.472138773641393}, {-0.2199307791404607, -0.6583691780274996, -0.7198475378926182}, {0.213923483450142, -0.1478171829550704, -0.9656017935214205}, {-0.1092625278784796, 0.481195157287321, -0.8697775121287253}};
    private final double x;
    private final double y;
    private final double z;

    Vec3d(LatLng latLng) {
        double r = Math.cos(latLng.getLatRad());
        this.z = Math.sin(latLng.getLatRad());
        this.x = Math.cos(latLng.getLonRad()) * r;
        this.y = Math.sin(latLng.getLonRad()) * r;
    }

    public double pointSquareDist(double[] v) {
        return this.square(this.x - v[0]) + this.square(this.y - v[1]) + this.square(this.z - v[2]);
    }

    private double square(double x) {
        return x * x;
    }
}

