/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.IndexTemplate;
import org.opensearch.client.opensearch.indices.SimulateTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class SimulateTemplateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SimulateTemplateRequest> {
    @Nullable
    private final String cause;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean create;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    @Nonnull
    private final IndexTemplate template;
    public static final JsonpDeserializer<SimulateTemplateRequest> _DESERIALIZER = SimulateTemplateRequest.createSimulateTemplateRequestDeserializer();
    public static final Endpoint<SimulateTemplateRequest, SimulateTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateTemplateRequest, SimulateTemplateResponse>(request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_index_template/_simulate";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template/_simulate/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateTemplateResponse._DESERIALIZER);

    private SimulateTemplateRequest(Builder builder) {
        super(builder);
        this.cause = builder.cause;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.create = builder.create;
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
    }

    public static SimulateTemplateRequest of(Function<Builder, ObjectBuilder<SimulateTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String cause() {
        return this.cause;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final IndexTemplate template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.template.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<SimulateTemplateRequest> createSimulateTemplateRequestDeserializer() {
        JsonpDeserializer<IndexTemplate> valueDeserializer = IndexTemplate._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().template((IndexTemplate)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.cause != null) {
            params.put("cause", this.cause);
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.create != null) {
            params.put("create", String.valueOf(this.create));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cause);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.create);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + this.template.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateTemplateRequest other = (SimulateTemplateRequest)o;
        return Objects.equals(this.cause, other.cause) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.create, other.create) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.name, other.name) && this.template.equals(other.template);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SimulateTemplateRequest> {
        @Nullable
        private String cause;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean create;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;
        private IndexTemplate template;

        public Builder() {
        }

        private Builder(SimulateTemplateRequest o) {
            super(o);
            this.cause = o.cause;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.template = o.template;
        }

        private Builder(Builder o) {
            super(o);
            this.cause = o.cause;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.template = o.template;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder cause(@Nullable String value) {
            this.cause = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder template(IndexTemplate value) {
            this.template = value;
            return this;
        }

        @Nonnull
        public final Builder template(Function<IndexTemplate.Builder, ObjectBuilder<IndexTemplate>> fn) {
            return this.template(fn.apply(new IndexTemplate.Builder()).build());
        }

        @Override
        @Nonnull
        public SimulateTemplateRequest build() {
            this._checkSingleUse();
            return new SimulateTemplateRequest(this);
        }
    }
}

