#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-GVlNqlmWifzFGNTotL1Mm6
key:                  postgrest-10.0.0-GVlNqlmWifzFGNTotL1Mm6
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  b654cf0cb61bf59da4ddf65a0db2b627
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-GVlNqlmWifzFGNTotL1Mm6
depends:
    HTTP-4000.4.1-B6UtN3UzBeCKl7E8Anf8ev
    Ranged-sets-0.5.0-GL9Q34BoSRhLRJUqCKKzkT
    aeson-2.2.0.0-A8FqDK4tVym6hhqwC7qXFC
    auto-update-0.1.6-CFZnQ0Ox4CLKHneRXaFnlC base-4.18.2.1
    base64-bytestring-1.2.1.0-4EosDDg3uRjHJpFgdqYthW
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-8vz9c08oERN6HaPlnW3IdE
    cassava-0.5.4.1-G45W0flyx9AAogeh6zsTo8
    configurator-pg-0.2.11-45nKJDkTTs35PxmoGoZg29 containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-9hRC76jO87lEtB307S4pUs
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-9Qb8IVKHGgRFHCAlwdYxGe
    hasql-dynamic-statements-0.3.1.1-1MDGjZuChrWKut984BOcWx
    hasql-notifications-0.2.0.5-FQBid4llp763CtOXSa50Yo
    hasql-pool-0.5.2.2-yuFzcKO6p0JuLf6S8Lsz2
    hasql-transaction-1.0.1.1-34qaqqm8UrS3OIhGoA0ueJ
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-5e6CiUpSQgfFBuPHItSqh0
    insert-ordered-containers-0.2.5.3-2bgvE8A7WciGhB6gKQa0ER
    interpolatedstring-perl6-1.0.2-2FlMg3U7dBq5yvJV0GVydF
    jose-0.10-IQ00h5oMmfn7F7a7xdcjMe lens-5.3.3-J3Ejqn7P12hA3GpyJcCxW8
    lens-aeson-1.2.3-C2CJaCWYHxLDOO1jdM33uG mtl-2.3.1
    network-3.1.4.0-6jdgASXXSsi4c1a8fEUR94
    network-uri-2.6.4.2-EsX0tHV5l49AhOs5hDRDmc
    optparse-applicative-0.18.1.0-LPpsyWWBTB8DZOwBIqw3J0
    parsec-3.1.16.1 protolude-0.3.5-2ASwOULEWu95GHhZQu1bEt
    regex-tdfa-1.3.2.5-DTLCNeui6jjF7PuXyFzkbb
    retry-0.9.3.1-Cr7hUkkzoqR30OjLhGs2rE
    scientific-0.3.8.0-JLcC8H5zZSyDPbVdOVmQEk
    swagger2-2.8.10-Ao6xFVCAKHV9jXnqOlyeBR text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    vault-0.3.1.5-LCnYMzw7SxtCZKjJNYArKS
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7
    wai-3.2.4-9STWQp0whD3L0eUd8mHjKL
    wai-cors-0.2.7-ANfbORbyWdpFTyKdW4Kku
    wai-extra-3.1.18-Fw46bdjxY258YVWejEXL3c
    wai-logger-2.5.0-GOyH7nYQCgkCzfgude3xxR
    warp-3.4.0-CSt5ad6OW639eJcnRwa3Em

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

