/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.moduleMembers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyMoveModuleMembersHelper {
    private PyMoveModuleMembersHelper() {
    }

    public static boolean isMovableModuleMember(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(0);
        }
        if (!PyMoveModuleMembersHelper.hasMovableElementType(element) || !PyUtil.isTopLevel((PsiElement)element)) {
            return false;
        }
        if (element instanceof PyTargetExpression) {
            return !"__all__".equals(((PyTargetExpression)element).getName()) && PyMoveModuleMembersHelper.isTargetOfSimpleAssignment(element);
        }
        return true;
    }

    public static boolean hasMovableElementType(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(1);
        }
        return element instanceof PyClass || element instanceof PyFunction || element instanceof PyTargetExpression;
    }

    public static boolean isTargetOfSimpleAssignment(@NotNull PsiElement element) {
        PyTargetExpression target;
        if (element == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(2);
        }
        if ((target = (PyTargetExpression)PyUtil.as((Object)element, PyTargetExpression.class)) == null || target.isQualified()) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PyUtil.as((Object)target.getParent(), PyAssignmentStatement.class);
        return assignment != null && assignment.getTargets().length == 1;
    }

    public static List<PyElement> getTopLevelModuleMembers(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(3);
        }
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        for (PyTargetExpression attr : pyFile.getTopLevelAttributes()) {
            if (!PyMoveModuleMembersHelper.isMovableModuleMember((PsiElement)attr)) continue;
            result2.add((PyElement)attr);
        }
        result2.addAll(pyFile.getTopLevelClasses());
        result2.addAll(pyFile.getTopLevelFunctions());
        return result2;
    }

    @Nullable
    public static PsiElement expandNamedElementBody(@NotNull PsiNamedElement element) {
        if (element == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(4);
        }
        if (element instanceof PyClass || element instanceof PyFunction) {
            return element;
        }
        if (element instanceof PyTargetExpression && element.getParent() instanceof PyAssignmentStatement) {
            return element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiNamedElement extractNamedElement(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(5);
        }
        if (element instanceof PyClass || element instanceof PyFunction || element instanceof PyTargetExpression) {
            return (PsiNamedElement)element;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PyUtil.as((Object)element, PyAssignmentStatement.class);
        if (assignment != null) {
            return (PsiNamedElement)PyUtil.as((Object)assignment.getTargets()[0], PyTargetExpression.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMovableModuleMember";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMovableElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTargetOfSimpleAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLevelModuleMembers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "expandNamedElementBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractNamedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

