\name{IterativeInverseDisplacementFieldImageFilter}
\alias{IterativeInverseDisplacementFieldImageFilter}
\title{IterativeInverseDisplacementFieldImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the inverse of a displacement field.
IterativeInverseDisplacementFieldImageFilter}
\details{
IterativeInverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.
The algorithm implemented in this filter uses an iterative method for
progressively refining the values of the inverse field. Starting from
the direct field, at every pixel the direct mapping of this point is
found, and a the negative of the current displacement is stored in the
inverse field at the nearest pixel. Then, subsequent iterations verify
if any of the neighbor pixels provide a better return to the current
pixel, in which case its value is taken for updating the vector in the
inverse field.
This method was discussed in the users-list during February 2004.
Corinne Mattmann
See:
IterativeInverseDisplacementField for the procedural interface
itk::IterativeInverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.
IterativeInverseDisplacementFieldImageFilter}
%C++ includes: sitkIterativeInverseDisplacementFieldImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetStopValue() const:}{}
\item{ IterativeInverseDisplacementFieldImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetStopValue(double StopValue):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~IterativeInverseDisplacementFieldImageFilter():}{
Destructor
}
}
}
