﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/socialmessaging/SocialMessaging_EXPORTS.h>
#include <aws/socialmessaging/model/WabaPhoneNumberSetupFinalization.h>
#include <aws/socialmessaging/model/WabaSetupFinalization.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SocialMessaging {
namespace Model {

/**
 * <p>The details of linking a WhatsApp Business Account to your Amazon Web
 * Services account.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/socialmessaging-2024-01-01/WhatsAppSetupFinalization">AWS
 * API Reference</a></p>
 */
class WhatsAppSetupFinalization {
 public:
  AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization() = default;
  AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization(Aws::Utils::Json::JsonView jsonValue);
  AWS_SOCIALMESSAGING_API WhatsAppSetupFinalization& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SOCIALMESSAGING_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An Amazon Web Services access token generated by
   * <code>WhatsAppSignupCallback</code> and used by
   * <code>WhatsAppSetupFinalization</code>.</p>
   */
  inline const Aws::String& GetAssociateInProgressToken() const { return m_associateInProgressToken; }
  inline bool AssociateInProgressTokenHasBeenSet() const { return m_associateInProgressTokenHasBeenSet; }
  template <typename AssociateInProgressTokenT = Aws::String>
  void SetAssociateInProgressToken(AssociateInProgressTokenT&& value) {
    m_associateInProgressTokenHasBeenSet = true;
    m_associateInProgressToken = std::forward<AssociateInProgressTokenT>(value);
  }
  template <typename AssociateInProgressTokenT = Aws::String>
  WhatsAppSetupFinalization& WithAssociateInProgressToken(AssociateInProgressTokenT&& value) {
    SetAssociateInProgressToken(std::forward<AssociateInProgressTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of WabaPhoneNumberSetupFinalization objects containing the details
   * of each phone number associated with the WhatsApp Business Account.</p>
   */
  inline const Aws::Vector<WabaPhoneNumberSetupFinalization>& GetPhoneNumbers() const { return m_phoneNumbers; }
  inline bool PhoneNumbersHasBeenSet() const { return m_phoneNumbersHasBeenSet; }
  template <typename PhoneNumbersT = Aws::Vector<WabaPhoneNumberSetupFinalization>>
  void SetPhoneNumbers(PhoneNumbersT&& value) {
    m_phoneNumbersHasBeenSet = true;
    m_phoneNumbers = std::forward<PhoneNumbersT>(value);
  }
  template <typename PhoneNumbersT = Aws::Vector<WabaPhoneNumberSetupFinalization>>
  WhatsAppSetupFinalization& WithPhoneNumbers(PhoneNumbersT&& value) {
    SetPhoneNumbers(std::forward<PhoneNumbersT>(value));
    return *this;
  }
  template <typename PhoneNumbersT = WabaPhoneNumberSetupFinalization>
  WhatsAppSetupFinalization& AddPhoneNumbers(PhoneNumbersT&& value) {
    m_phoneNumbersHasBeenSet = true;
    m_phoneNumbers.emplace_back(std::forward<PhoneNumbersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Used to add a new phone number to an existing WhatsApp Business Account. This
   * field can't be used when the <code>waba</code> field is present.</p>
   */
  inline const Aws::String& GetPhoneNumberParent() const { return m_phoneNumberParent; }
  inline bool PhoneNumberParentHasBeenSet() const { return m_phoneNumberParentHasBeenSet; }
  template <typename PhoneNumberParentT = Aws::String>
  void SetPhoneNumberParent(PhoneNumberParentT&& value) {
    m_phoneNumberParentHasBeenSet = true;
    m_phoneNumberParent = std::forward<PhoneNumberParentT>(value);
  }
  template <typename PhoneNumberParentT = Aws::String>
  WhatsAppSetupFinalization& WithPhoneNumberParent(PhoneNumberParentT&& value) {
    SetPhoneNumberParent(std::forward<PhoneNumberParentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Used to create a new WhatsApp Business Account and add a phone number. This
   * field can't be used when the <code>phoneNumberParent</code> field is
   * present.</p>
   */
  inline const WabaSetupFinalization& GetWaba() const { return m_waba; }
  inline bool WabaHasBeenSet() const { return m_wabaHasBeenSet; }
  template <typename WabaT = WabaSetupFinalization>
  void SetWaba(WabaT&& value) {
    m_wabaHasBeenSet = true;
    m_waba = std::forward<WabaT>(value);
  }
  template <typename WabaT = WabaSetupFinalization>
  WhatsAppSetupFinalization& WithWaba(WabaT&& value) {
    SetWaba(std::forward<WabaT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associateInProgressToken;

  Aws::Vector<WabaPhoneNumberSetupFinalization> m_phoneNumbers;

  Aws::String m_phoneNumberParent;

  WabaSetupFinalization m_waba;
  bool m_associateInProgressTokenHasBeenSet = false;
  bool m_phoneNumbersHasBeenSet = false;
  bool m_phoneNumberParentHasBeenSet = false;
  bool m_wabaHasBeenSet = false;
};

}  // namespace Model
}  // namespace SocialMessaging
}  // namespace Aws
