/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

abstract class VarDataFieldReader {
    private final CustomFieldContainer m_customFields;
    private static final int VALUE_LIST_WITH_ID_MASK = 1793;
    private static final int VALUE_LIST_WITHOUT_ID_MASK = 1025;

    public VarDataFieldReader(CustomFieldContainer customFields) {
        this.m_customFields = customFields;
    }

    public Object getValue(Var2Data varData, Integer id, Integer type) {
        Object result;
        int flag = varData.getShort(id, type);
        if (flag == 1793 || flag == 1025) {
            byte[] data = varData.getByteArray(id, type);
            int uniqueId = MPPUtility.getInt(data, 2);
            UUID guid = MPPUtility.getGUID(data, 6);
            CustomFieldValueItem item = uniqueId == -1 ? this.m_customFields.getCustomFieldValueItemByGuid(guid) : this.m_customFields.getCustomFieldValueItemByUniqueID(uniqueId);
            result = item == null ? guid : this.coerceValue(item.getValue());
        } else {
            result = this.readValue(varData, id, type);
        }
        return result;
    }

    protected abstract Object readValue(Var2Data var1, Integer var2, Integer var3);

    protected abstract Object coerceValue(Object var1);
}

