/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import org.jkiss.dbeaver.model.meta.SecureProperty;

public class PropertySerializationUtils {
    public static String EMPTY_JSON_OBJECT = "{}";

    public static GsonBuilder baseNonSecurePropertiesGsonBuilder() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new SecurePropertiesExclusionStrategy()}).setPrettyPrinting().setStrictness(Strictness.LENIENT);
    }

    public static GsonBuilder baseSecurePropertiesGsonBuilder() {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new NonSecurePropertiesExclusionStrategy()}).setPrettyPrinting().setStrictness(Strictness.LENIENT);
    }

    private static class NonSecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private NonSecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) == null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    private static class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

