/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class NativeToolWizardDialog
extends TaskConfigurationWizardDialog {
    public static final int CLIENT_CONFIG_ID = 1000;

    public NativeToolWizardDialog(@NotNull IWorkbenchWindow window, @NotNull TaskConfigurationWizard<?> wizard) {
        super(window, wizard);
        this.setupDialog();
    }

    public NativeToolWizardDialog(@NotNull IWorkbenchWindow window, @NotNull TaskConfigurationWizard<?> wizard, @NotNull IStructuredSelection selection) {
        super(window, wizard, selection);
        this.setupDialog();
    }

    protected void setupDialog() {
        this.setShellStyle(0xC70 | NativeToolWizardDialog.getDefaultOrientation());
        this.setHelpAvailable(false);
        this.setFinishButtonLabel(UIMessages.button_start);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean nativeClientRequired;
        if (this.getWizard() instanceof AbstractNativeToolWizard && (nativeClientRequired = ((AbstractNativeToolWizard)this.getWizard()).isNativeClientHomeRequired())) {
            parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.createButton(parent, 1000, TaskNativeUIMessages.tools_wizard_client_button, false);
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ++((GridLayout)parent.getLayout()).numColumns;
            ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        }
        super.createButtonsForButtonBar(parent);
    }

    public void disableButtonsOnProgress() {
        Button button = this.getButton(1000);
        if (button != null) {
            button.setEnabled(false);
        }
        super.disableButtonsOnProgress();
    }

    public void enableButtonsAfterProgress() {
        Button button = this.getButton(1000);
        if (button != null) {
            button.setEnabled(true);
        }
        super.enableButtonsAfterProgress();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            this.openClientConfiguration();
        }
        super.buttonPressed(buttonId);
    }

    private void openClientConfiguration() {
        NativeClientConfigDialog dialog;
        AbstractNativeToolWizard toolWizard = (AbstractNativeToolWizard)this.getWizard();
        DBPDataSourceContainer dataSource = toolWizard.getSettings().getDataSourceContainer();
        if (dataSource != null && (dialog = new NativeClientConfigDialog(this.getShell(), dataSource)).open() == 0) {
            if (toolWizard instanceof AbstractNativeToolWizard) {
                toolWizard.readLocalClientInfo();
            }
            this.updateButtons();
            this.updatePageCompletion();
        }
    }

    private static class NativeClientConfigDialog
    extends BaseDialog {
        private final DBPDataSourceContainer dataSource;
        private ClientHomesSelector homesSelector;

        public NativeClientConfigDialog(Shell parentShell, DBPDataSourceContainer dataSource) {
            super(parentShell, NLS.bind((String)TaskNativeUIMessages.tools_wizard_client_dialog_title, (Object)dataSource.getName()), dataSource.getDriver().getIcon());
            this.dataSource = dataSource;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            this.homesSelector = new ClientHomesSelector(dialogArea, TaskNativeUIMessages.tools_wizard_client_group_client);
            this.homesSelector.populateHomes(this.dataSource.getDriver(), this.dataSource.getConnectionConfiguration().getClientHomeId(), true);
            this.homesSelector.getPanel().setLayoutData((Object)new GridData(768));
            return dialogArea;
        }

        protected void okPressed() {
            String selectedHome = this.homesSelector.getSelectedHome();
            this.dataSource.getConnectionConfiguration().setClientHomeId(selectedHome);
            if (!this.dataSource.persistConfiguration()) {
                return;
            }
            super.okPressed();
        }
    }
}

