/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.swt.dnd.Transfer;

public class TemplateTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public TemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TemplateTransfer.getInstance());
    }

    @Override
    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory(TemplateTransfer.getInstance().getTemplate()));
        return request;
    }

    protected final CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof CreationFactory) {
            CreationFactory creationFactory = (CreationFactory)template;
            return creationFactory;
        }
        if (template instanceof Class) {
            Class clazz = (Class)template;
            return new SimpleFactory(clazz);
        }
        return null;
    }

    @Override
    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    @Override
    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    @Override
    protected void handleDrop() {
        super.handleDrop();
        this.selectAddedObject();
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        EditPart editPartForModel = viewer.getEditPartForModel(model);
        if (editPartForModel != null) {
            this.getViewer().flush();
            viewer.select(editPartForModel);
        }
    }

    @Override
    protected void updateTargetRequest() {
        CreateRequest request = this.getCreateRequest();
        request.setLocation(this.getDropLocation());
    }
}

