/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.jclf.text.TokenParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.DOMException;

public class DOMUtil {
    public static void parsePseudoAttributes(String data, Map<String, String> pseudoAttrs) throws DOMException {
        pseudoAttrs.clear();
        ArrayList<String> tokenlist = new ArrayList<String>(6);
        TokenParser tp = new TokenParser(data, " ", "\"'");
        while (tp.hasNext()) {
            tokenlist.add(tp.next().trim());
        }
        String token = null;
        String name = null;
        int stage = 0;
        Iterator iterator = tokenlist.iterator();
        while (iterator.hasNext()) {
            String value;
            int idx;
            String element;
            token = element = (String)iterator.next();
            if (stage == 0) {
                idx = token.indexOf(61);
                if (idx == -1) {
                    if (DOMUtil.invalidPseudoAttrName(token)) {
                        pseudoAttrs.clear();
                        DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + token);
                        return;
                    }
                    name = token;
                    stage = 1;
                    continue;
                }
                name = token.substring(0, idx);
                if (DOMUtil.invalidPseudoAttrName(name)) {
                    pseudoAttrs.clear();
                    DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + name);
                    return;
                }
                if (++idx != token.length()) {
                    value = token.substring(idx);
                    DOMUtil.setPseudoAttribute(pseudoAttrs, name, value);
                    name = null;
                    stage = 0;
                    continue;
                }
                stage = 2;
                continue;
            }
            if (stage == 1) {
                idx = token.indexOf(61);
                if (idx == 0) {
                    if (++idx != token.length()) {
                        value = token.substring(idx);
                        DOMUtil.setPseudoAttribute(pseudoAttrs, name, value);
                        name = null;
                        stage = 0;
                        continue;
                    }
                    stage = 2;
                    continue;
                }
                DOMUtil.parseError("Expected '=' in pseudo-attribute, instead found: " + token);
                return;
            }
            if (stage != 2) continue;
            pseudoAttrs.put(name, token);
            stage = 0;
        }
    }

    private static void parseError(String message) throws DOMException {
        throw new DOMException(5, message);
    }

    private static boolean invalidPseudoAttrName(String name) {
        if (!name.isEmpty()) {
            char[] na;
            for (char c : na = name.toCharArray()) {
                if (Character.isLetterOrDigit(c)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void setPseudoAttribute(Map<String, String> pseudoAttrs, String name, String value) {
        value = DOMUtil.parseValue(value);
        pseudoAttrs.put(name, value);
    }

    private static String parseValue(String value) {
        int fromIdx = value.indexOf("&");
        if (fromIdx == -1) {
            return value;
        }
        int len = value.length();
        int lenm3 = len - 3;
        StringBuilder buf = new StringBuilder(lenm3);
        buf.append(value.subSequence(0, fromIdx));
        ++fromIdx;
        while (fromIdx <= lenm3) {
            int idx = value.indexOf(";", fromIdx);
            if (idx != -1) {
                String ent = value.substring(fromIdx, idx).toLowerCase(Locale.ROOT);
                buf.append(DOMUtil.replaceEntity(ent));
                fromIdx = value.indexOf("&", ++idx);
                if (fromIdx != -1) {
                    if (idx < fromIdx) {
                        buf.append(value.subSequence(idx, fromIdx));
                    }
                    ++fromIdx;
                    continue;
                }
                fromIdx = idx;
                break;
            }
            DOMUtil.parseError("Malformed entity in PI: " + value);
            buf.append('&');
            break;
        }
        buf.append(value.subSequence(fromIdx, len));
        return buf.toString();
    }

    private static char replaceEntity(String ent) {
        int c;
        switch (ent) {
            case "amp": {
                c = 38;
                break;
            }
            case "lt": {
                c = 60;
                break;
            }
            case "gt": {
                c = 62;
                break;
            }
            case "quot": {
                c = 34;
                break;
            }
            case "apos": {
                c = 39;
                break;
            }
            default: {
                DOMUtil.parseError("Only predefined entities are valid in PI, not &" + ent + ';');
                c = 63;
            }
        }
        return (char)c;
    }
}

