/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.util;

import io.sf.carte.doc.style.css.util.Minify;
import io.sf.carte.uparser.MinificationHandler;
import io.sf.carte.uparser.TokenControl;
import java.util.Arrays;

class ShallowMinificationHandler
extends MinificationHandler {
    private final char preserveCommentChar;
    private static final char[] noSepAfter = new char[]{' ', '!', '(', ',', '/', ':', ';', '>', '[', '{', '}'};
    private static final char[] noSepBefore = new char[]{'!', ',', '/', ';', '<', '>'};

    ShallowMinificationHandler(StringBuilder buffer, Minify.ShallowConfig config) {
        super(buffer);
        this.preserveCommentChar = config.getPreserveCommentChar();
    }

    private static boolean isOrderedArray(char[] c) {
        char[] copy = Arrays.copyOf(c, c.length);
        Arrays.sort(copy);
        return Arrays.equals(copy, c);
    }

    private boolean whitespaceRequired() {
        return Arrays.binarySearch(noSepAfter, (char)this.getPreviousCodepoint()) < 0;
    }

    public void tokenStart(TokenControl control) {
        this.setPreviousCodepoint(32);
    }

    public void separator(int index, int codePoint) {
        if (this.whitespaceRequired()) {
            this.getBuffer().append(' ');
            this.setPreviousCodepoint(32);
        }
    }

    public void leftCurlyBracket(int index) {
        this.removeTrailingWhitespace();
        super.leftCurlyBracket(index);
    }

    public void rightParenthesis(int index) {
        this.removeTrailingWhitespace();
        super.rightParenthesis(index);
    }

    public void rightSquareBracket(int index) {
        this.removeTrailingWhitespace();
        super.rightSquareBracket(index);
    }

    public void rightCurlyBracket(int index) {
        this.removeTrailingWhitespace();
        this.removeTrailingCharacter(';');
        super.rightCurlyBracket(index);
    }

    public void character(int index, int codePoint) {
        if (Arrays.binarySearch(noSepBefore, (char)codePoint) >= 0) {
            this.removeTrailingWhitespace();
        }
        super.character(index, codePoint);
    }

    public void commented(int index, int commentType, String comment) {
        if (!comment.isEmpty() && comment.charAt(0) == this.preserveCommentChar) {
            this.removeTrailingWhitespace();
            this.getBuffer().append("/*").append(comment).append("*/");
        } else if (this.whitespaceRequired()) {
            this.getBuffer().append(' ');
        }
        this.setPreviousCodepoint(32);
    }

    private void removeTrailingWhitespace() {
        this.removeTrailingCharacter(' ');
    }

    private void removeTrailingCharacter(char c) {
        StringBuilder buffer = this.getBuffer();
        int len = buffer.length();
        if (len > 0 && buffer.charAt(--len) == c) {
            buffer.setLength(len);
        }
    }

    static {
        assert (ShallowMinificationHandler.isOrderedArray(noSepAfter));
        assert (ShallowMinificationHandler.isOrderedArray(noSepBefore));
    }
}

