/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import ghidra.jython.GhidraJythonInterpreter;
import ghidra.jython.JythonScript;
import java.util.concurrent.atomic.AtomicBoolean;
import org.python.core.PyException;
import org.python.core.PyObject;

class JythonScriptExecutionThread
extends Thread {
    private JythonScript script;
    private GhidraJythonInterpreter interpreter;
    private AtomicBoolean interpreterRunning;

    JythonScriptExecutionThread(JythonScript script, GhidraJythonInterpreter interpreter, AtomicBoolean interpreterRunning) {
        super("Jython script execution thread");
        this.script = script;
        this.interpreter = interpreter;
        this.interpreterRunning = interpreterRunning;
    }

    @Override
    public void run() {
        try {
            this.interpreter.execFile(this.script.getSourceFile(), this.script);
        }
        catch (PyException pye) {
            if (PyException.exceptionClassName((PyObject)pye.type).equalsIgnoreCase("exceptions.SystemExit")) {
                this.interpreter.printErr("SystemExit");
            } else {
                pye.printStackTrace();
            }
        }
        catch (StackOverflowError soe) {
            this.interpreter.printErr("Stack overflow!");
        }
        catch (IllegalStateException e) {
            this.interpreter.printErr(e.getMessage());
        }
        finally {
            this.interpreterRunning.set(false);
        }
    }
}

