/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.math.BigInteger;

public class LayeredColorModel
implements ListingBackgroundColorModel {
    private ListingBackgroundColorModel primaryModel;
    private ListingBackgroundColorModel secondaryModel;

    public LayeredColorModel(ListingBackgroundColorModel primary, ListingBackgroundColorModel secondary) {
        this.primaryModel = primary;
        this.secondaryModel = secondary;
    }

    public Color getBackgroundColor(BigInteger index) {
        Color primaryColor = this.primaryModel.getBackgroundColor(index);
        Color secondaryColor = this.secondaryModel.getBackgroundColor(index);
        if (primaryColor.equals(this.primaryModel.getDefaultBackgroundColor())) {
            return secondaryColor;
        }
        if (secondaryColor.equals(this.secondaryModel.getDefaultBackgroundColor())) {
            return primaryColor;
        }
        return this.blend(primaryColor, secondaryColor);
    }

    private Color blend(Color primary, Color secondary) {
        return ColorUtils.blend((Color)primary, (Color)secondary, (double)0.67);
    }

    public Color getDefaultBackgroundColor() {
        return this.primaryModel.getDefaultBackgroundColor();
    }

    public void setDefaultBackgroundColor(Color c) {
        this.primaryModel.setDefaultBackgroundColor(c);
        this.secondaryModel.setDefaultBackgroundColor(c);
    }

    @Override
    public void modelDataChanged(ListingPanel listingPanel) {
        this.primaryModel.modelDataChanged(listingPanel);
        this.secondaryModel.modelDataChanged(listingPanel);
    }
}

