/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal.vt;

import ghidra.app.plugin.core.terminal.vt.VtCharset;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtState;
import java.nio.ByteBuffer;

public class VtParser {
    protected final VtHandler handler;
    protected VtState state = VtState.CHAR;
    protected VtCharset.G csG;
    protected ByteBuffer csiParam = ByteBuffer.allocate(100);
    protected ByteBuffer csiInter = ByteBuffer.allocate(100);
    protected ByteBuffer oscParam = ByteBuffer.allocate(100);

    public VtParser(VtHandler handler) {
        this.handler = handler;
    }

    protected static ByteBuffer copyDoubledCapacity(ByteBuffer oldBuf) {
        ByteBuffer newBuf = ByteBuffer.allocate(oldBuf.capacity() * 2);
        oldBuf.flip();
        newBuf.put(oldBuf);
        return newBuf;
    }

    protected void putCsiParamByte(byte b) {
        if (!this.csiParam.hasRemaining()) {
            this.csiParam = VtParser.copyDoubledCapacity(this.csiParam);
        }
        this.csiParam.put(b);
    }

    protected void putCsiInterByte(byte b) {
        if (!this.csiInter.hasRemaining()) {
            this.csiInter = VtParser.copyDoubledCapacity(this.csiInter);
        }
        this.csiInter.put(b);
    }

    protected void putOscParamByte(byte b) {
        if (!this.oscParam.hasRemaining()) {
            this.oscParam = VtParser.copyDoubledCapacity(this.oscParam);
        }
        this.oscParam.put(b);
    }

    protected ByteBuffer copyCsiBuffer(byte b) {
        this.csiParam.flip();
        this.csiInter.flip();
        ByteBuffer buf = ByteBuffer.allocate(2 + this.csiParam.remaining() + this.csiInter.remaining());
        buf.put((byte)91);
        buf.put(this.csiParam);
        buf.put(this.csiInter);
        buf.put(b);
        this.csiParam.clear();
        this.csiInter.clear();
        return buf;
    }

    protected ByteBuffer copyOscBuffer(byte b) {
        this.oscParam.flip();
        ByteBuffer buf = ByteBuffer.allocate(2 + this.oscParam.remaining());
        buf.put((byte)93);
        buf.put(this.oscParam);
        buf.put(b);
        this.oscParam.clear();
        return buf;
    }

    public void process(ByteBuffer buf) {
        this.state = this.doProcess(this.state, buf);
    }

    protected VtState doProcessByte(VtState state, byte b) {
        return state.handleNext(b, this, this.handler);
    }

    protected VtState doProcess(VtState state, ByteBuffer buf) {
        while (buf.hasRemaining()) {
            state = this.doProcessByte(state, buf.get());
        }
        return state;
    }
}

