/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import generic.jar.ResourceFile;
import ghidra.app.cmd.comments.AppendCommentCmd;
import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWARFUtil {
    private static Pattern MANGLED_NESTING_REGEX = Pattern.compile("(.*_Z)?N([0-9]+.*)");
    private static final String OPERATOR_LT_STR = "operator<";
    private static final String OPERATOR_LSHIFT_STR = "operator<<";

    public static String toString(Class<?> clazz, int value) {
        return DWARFUtil.toString(clazz, Integer.toUnsignedLong(value));
    }

    public static String toString(Class<?> clazz, long value) {
        Field field = DWARFUtil.getStaticFinalFieldWithValue(clazz, value);
        return field != null ? field.getName() : "Unknown DWARF Value: 0x" + Long.toHexString(value);
    }

    public static Field getStaticFinalFieldWithValue(Class<?> clazz, long value) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                long fieldValue = field.getLong(null);
                if (fieldValue != value) continue;
                return field;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<String> parseMangledNestings(String s) {
        int len;
        ArrayList<String> results = new ArrayList<String>();
        Matcher m = MANGLED_NESTING_REGEX.matcher(s);
        if (!m.matches()) {
            return results;
        }
        s = m.group(2);
        for (int cp = 0; cp < s.length(); cp += len) {
            int start = cp;
            while (Character.isDigit(s.charAt(cp)) && cp < s.length()) {
                ++cp;
            }
            if (start == cp) break;
            len = Integer.parseInt(s.substring(start, cp));
            if (cp + len > s.length()) continue;
            String name = s.substring(cp, cp + len);
            results.add(name);
        }
        return results;
    }

    public static List<String> findLinkageNameInChildren(DebugInfoEntry die) {
        DWARFProgram prog = die.getProgram();
        for (DebugInfoEntry childDIE : die.getChildren(DWARFTag.DW_TAG_subprogram)) {
            List<String> nestings;
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            String linkage = childDIEA.getString(DWARFAttribute.DW_AT_linkage_name, null);
            if (linkage == null) {
                linkage = childDIEA.getString(DWARFAttribute.DW_AT_MIPS_linkage_name, null);
            }
            if (linkage == null || (nestings = DWARFUtil.parseMangledNestings(linkage)).isEmpty()) continue;
            nestings.remove(nestings.size() - 1);
            return nestings;
        }
        return List.of();
    }

    public static String getTemplateBaseName(String name) {
        int startOfTemplate = name.indexOf(60, name.startsWith(OPERATOR_LSHIFT_STR) ? OPERATOR_LSHIFT_STR.length() : (name.startsWith(OPERATOR_LT_STR) ? OPERATOR_LT_STR.length() : 0));
        return startOfTemplate > 0 && name.indexOf(62) > 0 ? name.substring(0, startOfTemplate).trim() : null;
    }

    public static String getAnonNameForMeFromParentContext(DIEAggregate diea) {
        DebugInfoEntry parent = diea.getHeadFragment().getParent();
        if (parent == null) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        int typeDefCount = 0;
        for (DebugInfoEntry childDIE : parent.getChildren()) {
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            if (diea == childDIEA || diea.getOffset() == childDIEA.getOffset()) {
                return "anon_%s_%d".formatted(childDIEA.getTag().getContainerTypeName(), typeDefCount);
            }
            if (!childDIEA.getTag().isNamedType()) continue;
            ++typeDefCount;
        }
        throw new RuntimeException("Could not find child in parent's list of children: child:\n" + String.valueOf(diea) + ",\nparent:\n" + String.valueOf(parent));
    }

    public static String getAnonNameForMeFromParentContext2(DIEAggregate diea) {
        DebugInfoEntry parent = diea.getHeadFragment().getParent();
        if (parent == null) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        ArrayList<String> users = new ArrayList<String>();
        for (DebugInfoEntry childDIE : parent.getChildren()) {
            DIEAggregate childDIEA = prog.getAggregate(childDIE);
            String childName = childDIEA.getName();
            DIEAggregate type = childDIEA.getTypeRef();
            if (type != diea || childName == null) continue;
            users.add(childName);
        }
        Collections.sort(users);
        if (users.isEmpty()) {
            return DWARFUtil.getAnonNameForMeFromParentContext(diea);
        }
        StringBuilder sb = new StringBuilder();
        for (String childName : users) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append(childName);
        }
        return "anon_" + diea.getTag().getContainerTypeName() + "_for_" + sb.toString();
    }

    public static String getStructLayoutFingerprint(DIEAggregate diea) {
        long structSize = diea.getUnsignedLong(DWARFAttribute.DW_AT_byte_size, 0L);
        int memberCount = 0;
        ArrayList<Object> memberNames = new ArrayList<Object>();
        for (DebugInfoEntry childEntry : diea.getHeadFragment().getChildren()) {
            DIEAggregate childDIEA;
            if (childEntry.getTag() != DWARFTag.DW_TAG_member && childEntry.getTag() != DWARFTag.DW_TAG_inheritance || (childDIEA = diea.getProgram().getAggregate(childEntry)).hasAttribute(DWARFAttribute.DW_AT_external)) continue;
            ++memberCount;
            Object memberName = childDIEA.getName();
            int memberOffset = 0;
            try {
                memberOffset = childDIEA.parseDataMemberOffset(DWARFAttribute.DW_AT_data_member_location, 0);
            }
            catch (DWARFExpressionException | IOException exception) {
                // empty catch block
            }
            if (memberName == null) {
                memberName = "UNNAMED_MEMBER_" + memberCount;
            }
            memberName = String.format("%04x_%s", memberOffset, memberName);
            memberNames.add(memberName);
        }
        Collections.sort(memberNames);
        return String.format("%d_%d_%08x", structSize, memberCount, memberNames.hashCode());
    }

    public static void appendDescription(DataType dt, String description, String sep) {
        if (description == null || description.isEmpty()) {
            return;
        }
        Object prev = dt.getDescription();
        if (prev == null) {
            prev = "";
        }
        if (!((String)prev).isEmpty()) {
            prev = (String)prev + sep;
        }
        dt.setDescription((String)prev + description);
    }

    public static void appendDescription(DataTypeComponent dtc, String description, String sep) {
        if (description == null || description.isEmpty()) {
            return;
        }
        Object prev = dtc.getComment();
        if (prev == null) {
            prev = "";
        }
        if (!((String)prev).isEmpty()) {
            prev = (String)prev + sep;
        }
        dtc.setComment((String)prev + description);
    }

    public static void appendComment(Program program, Address address, CommentType commentType, String prefix, String comment, String sep) {
        String existingComment;
        if (comment == null || comment.isBlank()) {
            return;
        }
        CodeUnit cu = DWARFUtil.getCodeUnitForComment(program, address);
        if (cu != null && (existingComment = cu.getComment(commentType)) != null && existingComment.contains(comment)) {
            return;
        }
        AppendCommentCmd cmd = new AppendCommentCmd(address, commentType, Objects.requireNonNullElse(prefix, "") + comment, sep);
        cmd.applyTo(program);
    }

    public static CodeUnit getCodeUnitForComment(Program program, Address address) {
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        if (cu == null) {
            return null;
        }
        Address cuAddr = cu.getMinAddress();
        if (cu instanceof Data && !address.equals((Object)cuAddr)) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)address.subtract(cuAddr));
        }
        return cu;
    }

    public static boolean isThisParam(DIEAggregate paramDIEA) {
        DWARFNumericAttribute dnum;
        String paramName = paramDIEA.getName();
        if (paramDIEA.getBool(DWARFAttribute.DW_AT_artificial, false) || "this".equals(paramName)) {
            return true;
        }
        DIEAggregate funcDIEA = paramDIEA.getParent();
        DWARFAttributeValue dwATObjectPointer = funcDIEA.getAttribute(DWARFAttribute.DW_AT_object_pointer);
        if (dwATObjectPointer != null && dwATObjectPointer instanceof DWARFNumericAttribute && paramDIEA.hasOffset((dnum = (DWARFNumericAttribute)dwATObjectPointer).getUnsignedValue())) {
            return true;
        }
        DIEAggregate classDIEA = funcDIEA.getParent();
        if (paramName == null && classDIEA != null && classDIEA.getTag().isStructureType()) {
            return DWARFUtil.isPointerTo(classDIEA, paramDIEA.getTypeRef());
        }
        return false;
    }

    public static boolean isPointerTo(DIEAggregate targetDIEA, DIEAggregate testDIEA) {
        return testDIEA != null && testDIEA.getTag() == DWARFTag.DW_TAG_pointer_type && testDIEA.getTypeRef() == targetDIEA;
    }

    public static boolean isPointerDataType(DIEAggregate diea) {
        while (diea.getTag() == DWARFTag.DW_TAG_typedef) {
            diea = diea.getTypeRef();
        }
        return diea.getTag() == DWARFTag.DW_TAG_pointer_type;
    }

    public static ResourceFile getLanguageExternalFile(Language lang, String name) throws IOException {
        String filename = DWARFUtil.getLanguageExternalNameValue(lang, name);
        return filename != null ? new ResourceFile(DWARFUtil.getLanguageDefinitionDirectory(lang), filename) : null;
    }

    public static ResourceFile getLanguageDefinitionDirectory(Language lang) throws IOException {
        LanguageDescription langDesc = lang.getLanguageDescription();
        if (!(langDesc instanceof SleighLanguageDescription)) {
            throw new IOException("Not a Sleigh Language: " + String.valueOf(lang.getLanguageID()));
        }
        SleighLanguageDescription sld = (SleighLanguageDescription)langDesc;
        ResourceFile defsFile = sld.getDefsFile();
        ResourceFile parentFile = defsFile.getParentFile();
        return parentFile;
    }

    public static String getLanguageExternalNameValue(Language lang, String name) throws IOException {
        LanguageDescription langDesc = lang.getLanguageDescription();
        if (!(langDesc instanceof SleighLanguageDescription)) {
            throw new IOException("Not a Sleigh Language: " + String.valueOf(lang.getLanguageID()));
        }
        List values = langDesc.getExternalNames(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IOException(String.format("Multiple external name values for %s found in language %s", name, lang.getLanguageID()));
        }
        return (String)values.get(0);
    }

    public static void packCompositeIfPossible(Composite original, DataTypeManager dtm) {
        DataTypeComponent[] postComps;
        if (original.isZeroLength() || original.getNumComponents() == 0) {
            return;
        }
        Composite copy = (Composite)original.copy(dtm);
        copy.setToDefaultPacking();
        if (copy.getLength() != original.getLength()) {
            return;
        }
        DataTypeComponent[] preComps = original.getDefinedComponents();
        if (preComps.length != (postComps = copy.getDefinedComponents()).length) {
            return;
        }
        for (int index = 0; index < preComps.length; ++index) {
            DataTypeComponent preDTC = preComps[index];
            DataTypeComponent postDTC = postComps[index];
            if (preDTC.getOffset() != postDTC.getOffset() || preDTC.getLength() != postDTC.getLength() || preDTC.isBitFieldComponent() != postDTC.isBitFieldComponent()) {
                return;
            }
            if (!preDTC.isBitFieldComponent()) continue;
            BitFieldDataType preBFDT = (BitFieldDataType)preDTC.getDataType();
            BitFieldDataType postBFDT = (BitFieldDataType)postDTC.getDataType();
            if (preBFDT.getBitOffset() == postBFDT.getBitOffset() && preBFDT.getBitSize() == postBFDT.getBitSize()) continue;
            return;
        }
        original.setToDefaultPacking();
    }

    public static List<Varnode> convertRegisterListToVarnodeStorage(List<Register> registers, int dataTypeSize) {
        ArrayList<Varnode> results = new ArrayList<Varnode>();
        for (Register reg : registers) {
            int regSize = reg.getMinimumByteSize();
            int bytesUsed = Math.min(dataTypeSize, regSize);
            Address addr = reg.getAddress();
            if (reg.isBigEndian() && bytesUsed < regSize) {
                addr = addr.add((long)(regSize - bytesUsed));
            }
            results.add(new Varnode(addr, bytesUsed));
            dataTypeSize -= bytesUsed;
        }
        return results;
    }

    public static boolean isEmptyArray(DataType dt) {
        Array array;
        return dt instanceof Array && (array = (Array)dt).getNumElements() == 0;
    }

    public static boolean isZeroByteDataType(DataType dt) {
        if (VoidDataType.dataType.isEquivalent(dt)) {
            return true;
        }
        if (!dt.isZeroLength() && dt instanceof Array) {
            dt = DataTypeUtilities.getArrayBaseDataType((Array)((Array)dt));
        }
        return dt.isZeroLength();
    }

    public static boolean isVoid(DataType dt) {
        return VoidDataType.dataType.isEquivalent(dt);
    }

    public static boolean isStackVarnode(Varnode varnode) {
        return varnode != null && varnode.getAddress().getAddressSpace().getType() == 5;
    }
}

