/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.rtti.GoApiSnapshot;
import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeBridge;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoTypeManager {
    private static final Map<String, String> STATIC_GOTYPE_ALIASES = Map.of("byte", "uint8", "rune", "int32", "*runtime.funcval", "func()");
    private static final Pattern TYPENAME_SPLITTER_REGEX = Pattern.compile("(\\*|\\[\\]|\\[[0-9.]+\\])(.*)");
    private final GoRttiMapper goBinary;
    private final DataTypeManager dtm;
    private final GoApiSnapshot apiSnapshot;
    private final Map<Long, TypeRec> typeOffsetIndex = new HashMap<Long, TypeRec>();
    private final Map<String, TypeRec> typeNameIndex = new HashMap<String, TypeRec>();
    private Set<String> missingGoTypes = new HashSet<String>();
    private GoType mapGoType;
    private GoType mapArgGoType;
    private GoType chanGoType;
    private GoType chanArgGoType;
    private Structure defaultClosureType;
    private Structure defaultMethodWrapperType;
    private DataType genericDictDT;
    private DataType uintptrDT;
    private DataType uintDT;
    private DataType int32DT;
    private DataType uint32DT;
    private DataType uint8DT;
    private DataType voidPtrDT;

    public GoTypeManager(GoRttiMapper goBinary, GoApiSnapshot apiSnapshot) {
        this.goBinary = goBinary;
        this.apiSnapshot = apiSnapshot;
        this.dtm = goBinary.getDTM();
    }

    public void init(TaskMonitor monitor) throws IOException {
        this.voidPtrDT = this.dtm.getPointer((DataType)VoidDataType.dataType);
        this.uintptrDT = this.goBinary.getTypeOrDefault("uintptr", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)this.goBinary.getPtrSize(), (DataTypeManager)this.dtm));
        this.uintDT = this.goBinary.getTypeOrDefault("uint", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)this.dtm.getDataOrganization().getIntegerSize(), (DataTypeManager)this.dtm));
        this.int32DT = this.goBinary.getTypeOrDefault("int32", DataType.class, AbstractIntegerDataType.getSignedDataType((int)4, null));
        this.uint32DT = this.goBinary.getTypeOrDefault("uint32", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)4, null));
        this.uint8DT = this.goBinary.getTypeOrDefault("uint8", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)1, null));
        this.genericDictDT = this.dtm.getPointer((DataType)this.dtm.getPointer(this.uintptrDT));
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        this.typeOffsetIndex.clear();
        this.typeNameIndex.clear();
        HashSet<Long> discoveredTypes = new HashSet<Long>();
        for (GoModuledata module : this.goBinary.getModules()) {
            upwtm.initialize(0L, "Iterating Golang RTTI types");
            for (Address typeAddr : module.getTypeList()) {
                if (upwtm.isCancelled()) {
                    throw new IOException("Failed to init type info: cancelled");
                }
                upwtm.setProgress((long)discoveredTypes.size());
                GoType goType = this.getTypeUnchecked(typeAddr);
                if (goType != null) {
                    goType.discoverGoTypes(discoveredTypes);
                    continue;
                }
                Msg.warn((Object)this, (Object)("Failed to read type at " + String.valueOf(typeAddr)));
            }
            upwtm.initialize(0L, "Iterating Golang Interfaces");
            for (GoItab itab : module.getItabs()) {
                if (upwtm.isCancelled()) {
                    throw new IOException("Failed to init type info: cancelled");
                }
                upwtm.setProgress((long)discoveredTypes.size());
                TypeRec rec = this.getTypeRec(itab.getType());
                if (rec.interfaces == null) {
                    rec.interfaces = new ArrayList<GoItab>();
                }
                rec.interfaces.add(itab);
                TypeRec ifaceRec = this.getTypeRec(itab.getInterfaceType());
                if (ifaceRec.interfaces == null) {
                    ifaceRec.interfaces = new ArrayList<GoItab>();
                }
                ifaceRec.interfaces.add(itab);
                itab.discoverGoTypes(discoveredTypes);
            }
            this.findUnindexedClosureStructTypes(monitor);
        }
        Msg.info((Object)this, (Object)"Found %d golang types".formatted(this.typeOffsetIndex.size()));
        this.mapGoType = this.findGoType("runtime.hmap");
        this.mapArgGoType = this.findGoType("*runtime.hmap", "uintptr");
        this.chanGoType = this.findGoType("runtime.hchan");
        this.chanArgGoType = this.findGoType("*runtime.hchan", "uintptr");
    }

    private long getAlignedEndOfTypeInfo(GoType type, int typeStructAlign) {
        try {
            return NumericUtilities.getUnsignedAlignedValue((long)type.getEndOfTypeInfo(), (long)typeStructAlign);
        }
        catch (IOException e) {
            return type.getTypeOffset();
        }
    }

    private void findUnindexedClosureStructTypes(TaskMonitor monitor) {
        int foundCount = 0;
        int typeStructAlign = this.goBinary.getPtrSize();
        int typeStructMinSize = this.goBinary.getStructureMappingInfo(GoStructType.class).getStructureLength();
        List<TypeStructRange> typeRanges = this.typeOffsetIndex.entrySet().stream().map(entry -> new TypeStructRange((Long)entry.getKey(), this.getAlignedEndOfTypeInfo(((TypeRec)entry.getValue()).type, typeStructAlign))).sorted((o1, o2) -> Long.compareUnsigned(o1.start, o2.start)).toList();
        for (int i = 1; i < typeRanges.size() - 1; ++i) {
            TypeStructRange t1 = typeRanges.get(i);
            TypeStructRange t2 = typeRanges.get(i + 1);
            long gapStart = t1.end;
            while (t2.start - gapStart > (long)typeStructMinSize) {
                GoType goType = this.readTypeUnchecked(gapStart);
                if (goType == null || !(goType instanceof GoStructType) || !goType.getSymbolName().isAnonType()) {
                    gapStart += (long)typeStructAlign;
                    continue;
                }
                TypeRec newTypeRec = this.getTypeRec(goType);
                gapStart = this.getAlignedEndOfTypeInfo(goType, typeStructAlign);
                ++foundCount;
            }
        }
        Msg.info((Object)this, (Object)"Discovered %d unindexed rtti types".formatted(foundCount));
    }

    private TypeRec getTypeRec(GoType goType) {
        long offset = goType.getStructureContext().getStructureStart();
        TypeRec prevRec = this.typeOffsetIndex.get(offset);
        if (prevRec != null) {
            return prevRec;
        }
        Object typeName = goType.getFullyQualifiedName();
        prevRec = this.typeNameIndex.get(typeName);
        if (prevRec != null) {
            ++prevRec.conflictCount;
            typeName = (String)typeName + ".conflict" + prevRec.conflictCount;
        }
        TypeRec newRec = new TypeRec();
        newRec.name = typeName;
        newRec.type = goType;
        this.typeOffsetIndex.put(offset, newRec);
        this.typeNameIndex.put((String)typeName, newRec);
        return newRec;
    }

    private TypeRec getTypeRec(long offset, boolean cacheOnly) throws IOException {
        if (offset == 0L) {
            return null;
        }
        TypeRec rec = this.typeOffsetIndex.get(offset);
        if (rec != null || cacheOnly) {
            return rec;
        }
        GoType goType = this.readType(offset);
        return this.getTypeRec(goType);
    }

    public DataTypeManager getDTM() {
        return this.dtm;
    }

    public List<GoType> allTypes() {
        return this.typeOffsetIndex.entrySet().stream().sorted((e1, e2) -> Long.compareUnsigned((Long)e1.getKey(), (Long)e2.getKey())).map(e -> ((TypeRec)e.getValue()).type).toList();
    }

    public List<Long> allTypeOffsets() {
        return this.typeOffsetIndex.keySet().stream().sorted().toList();
    }

    private GoType readTypeUnchecked(long offset) {
        try {
            return this.readType(offset);
        }
        catch (IOException e) {
            return null;
        }
    }

    private GoType readType(long offset) throws IOException {
        Class<? extends GoType> typeClass = GoType.getSpecializedTypeClass(this.goBinary, offset);
        GoType goType = this.goBinary.readStructure(typeClass, offset);
        return goType;
    }

    public GoType findGoType(String typeName) {
        return this.findGoType(typeName, null);
    }

    public GoType findGoType(GoSymbolName name) {
        return this.findGoType(name, null);
    }

    public GoType findGoType(GoSymbolName name, String defaultTypeName) {
        String typeName = name.asString();
        return this.findGoType(typeName, defaultTypeName);
    }

    public GoType findGoType(String typeName, String defaultTypeName) {
        String[] typeNameparts;
        TypeRec result = this.typeNameIndex.get(typeName = this.resolveTypeNameAliases(typeName));
        if (result == null && (typeNameparts = this.splitTypeName(typeName)) != null) {
            String subTypeFQN;
            String typePrefix = typeNameparts[0];
            String subTypeName = typeNameparts[1];
            GoType subType = this.findGoType(subTypeName);
            if (subType != null && !subTypeName.equals(subTypeFQN = subType.getFullyQualifiedName())) {
                return this.findGoType(typePrefix + subTypeFQN);
            }
        }
        if (result == null) {
            this.missingGoTypes.add(typeName);
        }
        if (result == null && defaultTypeName != null) {
            this.typeNameIndex.get(defaultTypeName);
        }
        return result != null ? result.type : null;
    }

    private String[] splitTypeName(String typeName) {
        Matcher m = TYPENAME_SPLITTER_REGEX.matcher(typeName);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public List<GoType> getClosureTypes() {
        return this.typeOffsetIndex.values().stream().filter(rec -> {
            GoStructType structType;
            GoType patt0$temp = rec.type;
            return patt0$temp instanceof GoStructType && (structType = (GoStructType)patt0$temp).isClosureContextType();
        }).map(rec -> rec.type).toList();
    }

    public List<GoType> getMethodWrapperClosureTypes() {
        return this.typeOffsetIndex.values().stream().filter(rec -> {
            GoStructType structType;
            GoType patt0$temp = rec.type;
            return patt0$temp instanceof GoStructType && (structType = (GoStructType)patt0$temp).isMethodWrapperContextType();
        }).map(rec -> rec.type).toList();
    }

    public GoType getType(long offset) throws IOException {
        return this.getType(offset, false);
    }

    public GoType getType(long offset, boolean cacheOnly) throws IOException {
        TypeRec rec = this.getTypeRec(offset, cacheOnly);
        return rec != null ? rec.type : null;
    }

    public GoType getType(Address addr) throws IOException {
        return this.getType(addr.getOffset(), false);
    }

    public GoType getTypeUnchecked(Address addr) {
        try {
            return this.getType(addr.getOffset(), false);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String resolveTypeNameAliases(String typeName) {
        String origTypeName = typeName;
        String result = STATIC_GOTYPE_ALIASES.get(typeName);
        if (result != null) {
            return result;
        }
        if (this.apiSnapshot != null) {
            GoApiSnapshot.GoTypeDef snapshotType;
            int loopCount = 0;
            while (!this.typeNameIndex.containsKey(typeName) && (snapshotType = this.apiSnapshot.getTypeDef(typeName)) != null) {
                if (snapshotType instanceof GoApiSnapshot.GoAliasDef) {
                    GoApiSnapshot.GoAliasDef aliasDef = (GoApiSnapshot.GoAliasDef)snapshotType;
                    typeName = aliasDef.Target;
                } else {
                    if (!(snapshotType instanceof GoApiSnapshot.GoBasicDef)) break;
                    GoApiSnapshot.GoBasicDef basicDef = (GoApiSnapshot.GoBasicDef)snapshotType;
                    typeName = basicDef.DataType;
                }
                if (loopCount++ <= 10) continue;
                return origTypeName;
            }
        }
        return typeName;
    }

    public GoType getMapGoType() {
        return this.mapGoType;
    }

    public GoType getMapArgGoType() {
        return this.mapArgGoType;
    }

    public GoType getChanGoType() {
        return this.chanGoType;
    }

    public GoType getChanArgGoType() {
        return this.chanArgGoType;
    }

    public DataType getUint8DT() {
        return this.uint8DT;
    }

    public DataType getUintDT() {
        return this.uintDT;
    }

    public DataType getUintptrDT() {
        return this.uintptrDT;
    }

    public DataType getInt32DT() {
        return this.int32DT;
    }

    public DataType getUint32DT() {
        return this.uint32DT;
    }

    public DataType getVoidPtrDT() {
        return this.voidPtrDT;
    }

    public String getTypeName(long offset) {
        try {
            TypeRec rec = this.getTypeRec(offset, false);
            if (rec != null) {
                return rec.name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown_type_%x".formatted(offset);
    }

    public String getTypeName(GoType type) {
        return this.getTypeName(type.getStructureContext().getStructureStart());
    }

    public List<GoItab> getInterfacesImplementedByType(GoType type) {
        TypeRec rec = this.getTypeRec(type);
        List<Object> itabs = rec.interfaces != null ? rec.interfaces : List.of();
        return itabs.stream().filter(itab -> itab._type == type.getTypeOffset()).toList();
    }

    public List<GoItab> getTypesThatImplementInterface(GoInterfaceType iface) {
        TypeRec rec = this.getTypeRec(iface);
        List<Object> itabs = rec.interfaces != null ? rec.interfaces : List.of();
        return itabs.stream().filter(itab -> itab.inter == iface.getTypeOffset()).toList();
    }

    public GoType resolveTypeOff(long ptrInModule, long off) throws IOException {
        if (off == 0L || off == 0xFFFFFFFFL || off == -1L) {
            return null;
        }
        GoModuledata module = this.goBinary.findContainingModule(ptrInModule);
        return this.getType(module.getTypesOffset() + off, false);
    }

    public void cacheRecoveredDataType(GoType typ, DataType dt) throws IOException {
        TypeRec rec = this.getTypeRec(typ);
        rec.recoveredDT = dt;
    }

    public DataType getGhidraDataType(GoType typ) throws IOException {
        return this.getGhidraDataType(typ, DataType.class, false);
    }

    public <T extends DataType> T getGhidraDataType(GoType typ, Class<T> clazz, boolean cacheOnly) throws IOException {
        DataType dt;
        if (typ == null) {
            return null;
        }
        if (typ instanceof GoTypeBridge) {
            GoTypeBridge typeBridge = (GoTypeBridge)typ;
            DataType dt2 = typeBridge.recoverDataType(this);
            return (T)(clazz.isInstance(dt2) ? (DataType)clazz.cast(dt2) : null);
        }
        TypeRec rec = this.getTypeRec(typ);
        if (rec.recoveredDT == null && !cacheOnly) {
            rec.recoveredDT = typ.recoverDataType(this);
        }
        if (clazz.isInstance(dt = rec.recoveredDT)) {
            return (T)((DataType)clazz.cast(dt));
        }
        if (dt != null) {
            Msg.warn((Object)this, (Object)"Failed to get Ghidra data type from go type: %s[%x]".formatted(rec.name, rec.type.getStructureContext().getStructureStart()));
        }
        return null;
    }

    public <T extends DataType> T getGhidraDataType(String goTypeName, Class<T> clazz) throws IOException {
        GoType typ = this.findGoType(goTypeName);
        return typ != null ? (T)this.getGhidraDataType(typ, clazz, false) : null;
    }

    public CategoryPath getCP() {
        return GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
    }

    public CategoryPath getCP(GoType typ) {
        CategoryPath result = GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
        try {
            String structNS = typ.getStructureNamespace();
            if (structNS != null && !structNS.isEmpty()) {
                result = result.extend(new String[]{structNS});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public CategoryPath getCP(GoSymbolName symbolName) {
        CategoryPath result = GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
        String packagePath = symbolName.getPackagePath();
        if (packagePath != null && !packagePath.isEmpty()) {
            result = result.extend(new String[]{packagePath});
        }
        return result;
    }

    public Structure getGenericSliceDT() {
        return this.goBinary.getStructureDataType(GoSlice.class);
    }

    public DataType getGenericDictDT() {
        return this.genericDictDT;
    }

    public Structure getGenericInterfaceDT() {
        return this.goBinary.getStructureDataType(GoIface.class);
    }

    public Structure getGenericITabDT() {
        return this.goBinary.getStructureDataType(GoItab.class);
    }

    public DataType getMethodClosureType(String recvType) throws IOException {
        GoType closureType = this.findGoType("struct { F uintptr; R %s }".formatted(recvType));
        return closureType != null ? this.getGhidraDataType(closureType) : null;
    }

    GoType findRecieverType(GoSymbolName symbolName) {
        GoSymbolName recvTypeName = symbolName.getReceiverTypeName();
        GoType result = this.findGoType(recvTypeName);
        if (result == null && symbolName.hasGenerics()) {
            recvTypeName = symbolName.getReceiverTypeName(symbolName.getShapelessGenericsString());
            result = this.findGoType(recvTypeName);
        }
        return result;
    }

    public DataType getDefaultClosureType() {
        if (this.defaultClosureType == null) {
            StructureDataType closureDT = new StructureDataType(this.getCP(), ".closure", 0, this.dtm);
            closureDT.setDescription("Artifical type that represents a golang closure context");
            FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.getCP(), ".closureF", this.dtm);
            ParameterDefinition[] params = new ParameterDefinition[]{new ParameterDefinitionImpl(".context", (DataType)this.dtm.getPointer((DataType)closureDT), null)};
            funcDef.setArguments(params);
            closureDT.add((DataType)this.dtm.getPointer((DataType)funcDef), "F", null);
            closureDT.add((DataType)new ArrayDataType(this.uint8DT, 0), "context", null);
            this.defaultClosureType = (Structure)this.dtm.addDataType((DataType)closureDT, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
        return this.defaultClosureType;
    }

    public Structure getDefaultMethodWrapperClosureType() {
        if (this.defaultMethodWrapperType == null) {
            StructureDataType closureDT = new StructureDataType(this.getCP(), ".methodwrapper", 0, this.dtm);
            FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.getCP(), ".methodwrapperF", this.dtm);
            ParameterDefinition[] params = new ParameterDefinition[]{new ParameterDefinitionImpl(".context", (DataType)this.dtm.getPointer((DataType)closureDT), null)};
            funcDef.setArguments(params);
            closureDT.add((DataType)this.dtm.getPointer((DataType)funcDef), "F", null);
            closureDT.add(this.voidPtrDT, "R", "method receiver");
            this.defaultMethodWrapperType = (Structure)this.dtm.addDataType((DataType)closureDT, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
        return this.defaultMethodWrapperType;
    }

    public Structure getFuncMultiReturn(List<DataType> returnTypes) {
        GoFunctionMultiReturn multiReturn = new GoFunctionMultiReturn(this.getCP(), returnTypes, this.dtm, this.goBinary.newStorageAllocator());
        return multiReturn.getStruct();
    }

    public GoType getSubstitutionType(String typeName) {
        if (typeName.startsWith("*")) {
            return new GoTypeBridge(typeName, this.getVoidPtrDT(), this.goBinary);
        }
        if (typeName.startsWith("[]") || typeName.equals("runtime.slice")) {
            return new GoTypeBridge(typeName, (DataType)this.getGenericSliceDT(), this.goBinary);
        }
        if (typeName.startsWith("map[")) {
            return this.mapArgGoType;
        }
        if (typeName.startsWith("chan ")) {
            return this.chanArgGoType;
        }
        if (typeName.startsWith("func(")) {
            DataType closureType = this.getDefaultClosureType();
            return new GoTypeBridge(typeName, (DataType)this.dtm.getPointer(closureType), this.goBinary);
        }
        if (typeName.equals("runtime.iface")) {
            return new GoTypeBridge(typeName, (DataType)this.getGenericInterfaceDT(), this.goBinary);
        }
        return null;
    }

    public Set<String> getMissingGoTypes() {
        return this.missingGoTypes;
    }

    static class TypeRec {
        GoType type;
        String name;
        int conflictCount;
        DataType recoveredDT;
        List<GoItab> interfaces;

        TypeRec() {
        }
    }

    record TypeStructRange(long start, long end) {
    }
}

