/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.RenameMemoryBlockQuickFix;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryBlockSearchAndReplaceHandler
extends SearchAndReplaceHandler {
    public MemoryBlockSearchAndReplaceHandler() {
        this.addType(new SearchType(this, "Memory Blocks", "Search and replace memory block names"));
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        Memory memory = program.getMemory();
        MemoryBlock[] blocks = memory.getBlocks();
        monitor.initialize((long)blocks.length, "Searching MemoryBlocks...");
        Pattern pattern = query.getSearchPattern();
        for (MemoryBlock block : blocks) {
            monitor.increment();
            Matcher matcher = pattern.matcher(block.getName());
            if (!matcher.find()) continue;
            String newName = matcher.replaceAll(query.getReplacementText());
            RenameMemoryBlockQuickFix item = new RenameMemoryBlockQuickFix(program, block, newName);
            accumulator.add((Object)item);
        }
    }
}

