/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import generic.Span;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.DisplaysModified;
import ghidra.app.plugin.core.debug.gui.model.DisplaysObjectValues;
import ghidra.app.plugin.core.debug.gui.model.KeepTreeState;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceObjectEventScope;
import ghidra.trace.model.target.iface.TraceObjectTogglable;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HTMLUtilities;
import ghidra.util.LockHold;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import utilities.util.IDKeyed;

public class ObjectTreeModel
implements DisplaysModified {
    public static final GIcon ICON_PENDING = new GIcon("icon.pending");
    private Trace trace;
    private long snap;
    private Trace diffTrace;
    private long diffSnap;
    private Lifespan span = Lifespan.ALL;
    private boolean showHidden;
    private boolean showPrimitives;
    private boolean showMethods;
    private final RootNode root = new RootNode();
    private final NodeCache nodeCache = new NodeCache();
    private Map<String, Icon> icons = this.fillIconMap(new HashMap<String, Icon>());
    private final ListenerForChanges listenerForChanges = this.newListenerForChanges();
    protected final DisplaysObjectValues display = new TreeDisplaysObjectValues();
    protected final DisplaysObjectValues diffDisplay = new DiffTreeDisplaysObjectValues();

    protected ListenerForChanges newListenerForChanges() {
        return new ListenerForChanges();
    }

    protected Map<String, Icon> fillIconMap(Map<String, Icon> map) {
        map.put("Process", DebuggerResources.ICON_PROCESS);
        map.put("Thread", DebuggerResources.ICON_THREAD);
        map.put("Memory", DebuggerResources.ICON_REGIONS);
        map.put("Interpreter", DebuggerResources.ICON_CONSOLE);
        map.put("Console", DebuggerResources.ICON_CONSOLE);
        map.put("Stack", DebuggerResources.ICON_PROVIDER_STACK);
        map.put("BreakpointContainer", DebuggerResources.ICON_BREAKPOINTS);
        map.put("BreakpointLocationContainer", DebuggerResources.ICON_BREAKPOINTS);
        map.put("RegisterContainer", DebuggerResources.ICON_REGISTERS);
        map.put("ModuleContainer", DebuggerResources.ICON_MODULES);
        return map;
    }

    protected TraceObject getEventObject(TraceObject object) {
        TraceObject scope = object.findCanonicalAncestorsInterface(TraceObjectEventScope.class).findFirst().orElse(null);
        if (scope == null) {
            return null;
        }
        if (scope == object) {
            return null;
        }
        TraceObjectValue eventValue = scope.getAttribute(this.snap, "_event_thread");
        if (eventValue == null || !eventValue.isObject()) {
            return null;
        }
        return eventValue.getChild();
    }

    protected boolean isOnEventPath(TraceObject object) {
        TraceObject eventObject = this.getEventObject(object);
        if (eventObject == null) {
            return false;
        }
        return object.getCanonicalPath().isAncestor(eventObject.getCanonicalPath());
    }

    protected Icon getObjectIcon(TraceObjectValue edge, boolean expanded) {
        String type = this.display.getObjectType(edge);
        Icon forType = this.icons.get(type);
        if (forType != null) {
            return forType;
        }
        if (type.contains("Breakpoint") || type.contains("Watchpoint")) {
            TraceObject object = edge.getChild();
            TraceObjectValue en = object.getAttribute(this.snap, "_enabled");
            if (en == null || !Objects.equals(false, en.getValue())) {
                return DebuggerResources.ICON_SET_BREAKPOINT;
            }
            return DebuggerResources.ICON_DISABLE_BREAKPOINT;
        }
        return DebuggerResources.ICON_OBJECT_POPULATED;
    }

    protected boolean isValueVisible(TraceObjectValue value) {
        if (!this.showHidden && value.isHidden()) {
            return false;
        }
        if (!this.showPrimitives && !value.isObject()) {
            return false;
        }
        return this.showMethods || !value.isObject() || !value.getChild().isMethod(this.snap);
    }

    @Override
    public boolean isEdgesDiffer(TraceObjectValue newEdge, TraceObjectValue oldEdge) {
        if (DisplaysModified.super.isEdgesDiffer(newEdge, oldEdge)) {
            return true;
        }
        return !Objects.equals(this.diffDisplay.getEdgeDisplay(oldEdge), this.display.getEdgeDisplay(newEdge));
    }

    protected List<GTreeNode> generateObjectChildren(TraceObject object) {
        List<GTreeNode> result = ObjectTableModel.distinctCanonical(object.getValues(this.span).stream().filter(this::isValueVisible)).map(v -> this.nodeCache.getOrCreateNode((TraceObjectValue)v)).sorted().collect(Collectors.toList());
        return result;
    }

    public GTreeLazyNode getRoot() {
        return this.root;
    }

    protected void removeOldListeners() {
        if (this.trace != null) {
            this.trace.removeListener((DomainObjectListener)this.listenerForChanges);
            this.trace.removeCloseListener((DomainObjectClosedListener)this.listenerForChanges);
        }
    }

    protected void addNewListeners() {
        if (this.trace != null) {
            this.trace.addListener((DomainObjectListener)this.listenerForChanges);
            this.trace.addCloseListener((DomainObjectClosedListener)this.listenerForChanges);
        }
    }

    protected void refresh() {
        for (AbstractNode node : this.nodeCache.byObject.values()) {
            node.fireNodeChanged();
        }
        this.root.fireNodeChanged();
    }

    protected void reload() {
        this.nodeCache.invalidate();
        this.root.unloadChildren();
    }

    protected void reloadSameTrace() {
        try (LockHold hold = this.trace == null ? null : this.trace.lockRead();){
            for (AbstractNode node : List.copyOf(this.nodeCache.byObject.values())) {
                node.reloadChildrenNow();
                node.fireNodeChanged();
            }
            this.root.reloadChildrenNow();
            this.root.fireNodeChanged();
        }
    }

    public void setTrace(Trace trace) {
        if (this.trace == trace) {
            return;
        }
        this.removeOldListeners();
        this.trace = trace;
        this.addNewListeners();
        this.traceChanged();
    }

    protected void traceChanged() {
        this.reload();
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    protected void snapChanged() {
        this.refresh();
    }

    public void setSnap(long snap) {
        if (this.snap == snap) {
            return;
        }
        this.snap = snap;
        this.snapChanged();
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    protected void diffTraceChanged() {
        this.refresh();
    }

    public void setDiffTrace(Trace diffTrace) {
        if (this.diffTrace == diffTrace) {
            return;
        }
        this.diffTrace = diffTrace;
        this.diffTraceChanged();
    }

    @Override
    public Trace getDiffTrace() {
        return this.diffTrace;
    }

    protected void diffSnapChanged() {
        this.refresh();
    }

    public void setDiffSnap(long diffSnap) {
        if (this.diffSnap == diffSnap) {
            return;
        }
        this.diffSnap = diffSnap;
        this.diffSnapChanged();
    }

    @Override
    public long getDiffSnap() {
        return this.diffSnap;
    }

    protected void spanChanged() {
        this.reloadSameTrace();
    }

    public void setSpan(Lifespan span) {
        if (Objects.equals(this.span, span)) {
            return;
        }
        this.span = span;
        this.spanChanged();
    }

    public Lifespan getSpan() {
        return this.span;
    }

    protected void showHiddenChanged() {
        this.reloadSameTrace();
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        this.showHiddenChanged();
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    protected void showPrimitivesChanged() {
        this.reloadSameTrace();
    }

    public void setShowPrimitives(boolean showPrimitives) {
        if (this.showPrimitives == showPrimitives) {
            return;
        }
        this.showPrimitives = showPrimitives;
        this.showPrimitivesChanged();
    }

    public boolean isShowPrimitives() {
        return this.showPrimitives;
    }

    protected void showMethodsChanged() {
        this.reloadSameTrace();
    }

    public void setShowMethods(boolean showMethods) {
        if (this.showMethods == showMethods) {
            return;
        }
        this.showMethods = showMethods;
        this.showMethodsChanged();
    }

    public boolean isShowMethods() {
        return this.showMethods;
    }

    public AbstractNode getNode(KeyPath p) {
        return this.root.getNode(p);
    }

    public class RootNode
    extends AbstractNode {
        @Override
        public TraceObjectValue getValue() {
            if (ObjectTreeModel.this.trace == null) {
                return null;
            }
            TraceObject root = ObjectTreeModel.this.trace.getObjectManager().getRootObject();
            if (root == null) {
                return null;
            }
            return root.getCanonicalParent(0L);
        }

        @Override
        public String getName() {
            return "<Root>";
        }

        @Override
        public String getDisplayText() {
            if (ObjectTreeModel.this.trace == null) {
                return "<html><em>No&nbsp;trace&nbsp;is&nbsp;active</em>";
            }
            TraceObject root = ObjectTreeModel.this.trace.getObjectManager().getRootObject();
            if (root == null) {
                return "<html><em>Trace&nbsp;has&nbsp;no&nbsp;model</em>";
            }
            return "<html>" + HTMLUtilities.escapeHTML((String)ObjectTreeModel.this.display.getObjectDisplay(root.getCanonicalParent(0L)), (boolean)true);
        }

        public Icon getIcon(boolean expanded) {
            return DebuggerResources.ICON_DEBUGGER;
        }

        public String getToolTip() {
            if (ObjectTreeModel.this.trace == null) {
                return "No trace is active";
            }
            TraceObject root = ObjectTreeModel.this.trace.getObjectManager().getRootObject();
            if (root == null) {
                return "Trace has no model";
            }
            return ObjectTreeModel.this.display.getObjectToolTip(root.getCanonicalParent(0L));
        }

        public boolean isLeaf() {
            return false;
        }

        protected List<GTreeNode> generateChildren() {
            if (ObjectTreeModel.this.trace == null) {
                return List.of();
            }
            TraceObject root = ObjectTreeModel.this.trace.getObjectManager().getRootObject();
            if (root == null) {
                return List.of();
            }
            return ObjectTreeModel.this.generateObjectChildren(root);
        }

        @Override
        protected boolean isModified() {
            return false;
        }

        @Override
        protected void childCreated(TraceObjectValue value) {
            if (!ObjectTreeModel.this.isValueVisible(value)) {
                return;
            }
            if (ObjectTreeModel.this.nodeCache.getByValue(value) != null) {
                super.childCreated(value);
                return;
            }
            try (KeepTreeState keep = KeepTreeState.ifNotNull(this.getTree());){
                this.unloadChildren();
            }
        }
    }

    class NodeCache {
        Map<IDKeyed<TraceObjectValue>, AbstractNode> byValue = new WeakValueHashMap();
        Map<IDKeyed<TraceObject>, AbstractNode> byObject = new WeakValueHashMap();

        NodeCache() {
        }

        protected AbstractNode createNode(TraceObjectValue value) {
            if (value.isCanonical()) {
                return new CanonicalNode(value);
            }
            if (value.isObject()) {
                return new LinkNode(value);
            }
            return new PrimitiveNode(value);
        }

        protected AbstractNode getOrCreateNode(TraceObjectValue value) {
            if (value.getParent() == null) {
                ObjectTreeModel.this.root.unloadChildren();
                return ObjectTreeModel.this.root;
            }
            AbstractNode node = this.byValue.computeIfAbsent((IDKeyed<TraceObjectValue>)new IDKeyed((Object)value), k -> this.createNode(value));
            if (value.isCanonical()) {
                this.byObject.put((IDKeyed<TraceObject>)new IDKeyed((Object)value.getChild()), node);
            }
            return node;
        }

        protected AbstractNode getByValue(TraceObjectValue value) {
            return this.byValue.get(new IDKeyed((Object)value));
        }

        protected AbstractNode getByObject(TraceObject object) {
            if (object.isRoot()) {
                return ObjectTreeModel.this.root;
            }
            return this.byObject.get(new IDKeyed((Object)object));
        }

        public void invalidate() {
            this.byObject.clear();
            this.byValue.clear();
        }
    }

    class ListenerForChanges
    extends TraceDomainObjectListener
    implements DomainObjectClosedListener {
        public ListenerForChanges() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, this::domainObjectRestored);
            this.listenFor((TraceEvent)TraceEvents.OBJECT_CREATED, this::objectCreated);
            this.listenFor((TraceEvent)TraceEvents.VALUE_CREATED, this::valueCreated);
            this.listenFor((TraceEvent)TraceEvents.VALUE_DELETED, this::valueDeleted);
            this.listenFor((TraceEvent)TraceEvents.VALUE_LIFESPAN_CHANGED, this::valueLifespanChanged);
        }

        public void domainObjectClosed(DomainObject dobj) {
            ObjectTreeModel.this.setTrace(null);
        }

        public void domainObjectRestored(DomainObjectChangeRecord rec) {
            ObjectTreeModel.this.reloadSameTrace();
        }

        protected boolean isEventValue(TraceObjectValue value) {
            if (!value.getParent().getSchema().getInterfaces().contains(TraceObjectEventScope.class)) {
                return false;
            }
            return "_event_thread".equals(value.getEntryKey());
        }

        protected boolean isEnabledValue(TraceObjectValue value) {
            Set interfaces = value.getParent().getSchema().getInterfaces();
            if (!(interfaces.contains(TraceObjectBreakpointSpec.class) || interfaces.contains(TraceObjectBreakpointLocation.class) || interfaces.contains(TraceObjectTogglable.class))) {
                return false;
            }
            return "_enabled".equals(value.getEntryKey());
        }

        private void objectCreated(TraceObject object) {
            if (object.isRoot()) {
                ObjectTreeModel.this.reload();
            }
        }

        private void valueCreated(TraceObjectValue value) {
            if (!value.getLifespan().intersects((Span)ObjectTreeModel.this.span)) {
                return;
            }
            AbstractNode node = ObjectTreeModel.this.nodeCache.getByObject(value.getParent());
            if (node == null) {
                return;
            }
            if (this.isEventValue(value)) {
                ObjectTreeModel.this.refresh();
            }
            if (this.isEnabledValue(value)) {
                node.fireNodeChanged();
            }
            node.childCreated(value);
        }

        private void valueDeleted(TraceObjectValue value) {
            if (!value.getLifespan().intersects((Span)ObjectTreeModel.this.span)) {
                return;
            }
            AbstractNode node = ObjectTreeModel.this.nodeCache.getByObject(value.getParent());
            if (node == null) {
                return;
            }
            if (this.isEventValue(value)) {
                ObjectTreeModel.this.refresh();
            }
            if (this.isEnabledValue(value)) {
                node.fireNodeChanged();
            }
            node.childDeleted(value);
        }

        private void valueLifespanChanged(TraceObjectValue value, Lifespan oldSpan, Lifespan newSpan) {
            boolean inNew;
            boolean inOld = oldSpan.intersects((Span)ObjectTreeModel.this.span);
            if (inOld == (inNew = newSpan.intersects((Span)ObjectTreeModel.this.span))) {
                return;
            }
            AbstractNode node = ObjectTreeModel.this.nodeCache.getByObject(value.getParent());
            if (node == null) {
                return;
            }
            if (this.isEventValue(value)) {
                ObjectTreeModel.this.refresh();
            }
            if (this.isEnabledValue(value)) {
                node.fireNodeChanged();
            }
            if (inNew) {
                node.childCreated(value);
            } else {
                node.childDeleted(value);
            }
        }
    }

    protected class TreeDisplaysObjectValues
    implements LastKeyDisplaysObjectValues {
        protected TreeDisplaysObjectValues() {
        }

        @Override
        public long getSnap() {
            return ObjectTreeModel.this.snap;
        }
    }

    protected class DiffTreeDisplaysObjectValues
    implements LastKeyDisplaysObjectValues {
        protected DiffTreeDisplaysObjectValues() {
        }

        @Override
        public long getSnap() {
            return ObjectTreeModel.this.diffSnap;
        }
    }

    public abstract class AbstractNode
    extends GTreeLazyNode {
        public abstract TraceObjectValue getValue();

        public synchronized void addNodeSorted(AbstractNode node) {
            int i = Collections.binarySearch(this.getChildren(), node);
            if (i >= 0) {
                throw new AssertionError((Object)("Duplicate node name: " + node.getName()));
            }
            i = -i - 1;
            this.addNode(i, (GTreeNode)node);
        }

        public void dispose() {
        }

        public int compareTo(GTreeNode node) {
            if (!(node instanceof AbstractNode)) {
                return -1;
            }
            AbstractNode that = (AbstractNode)node;
            int c = KeyPath.KeyComparator.CHILD.compare((Object)this.getValue().getEntryKey(), (Object)that.getValue().getEntryKey());
            if (c != 0) {
                return c;
            }
            c = Lifespan.DOMAIN.compare(this.getValue().getMinSnap(), that.getValue().getMinSnap());
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public String getName() {
            return this.getValue().getEntryKey() + "@" + System.identityHashCode(this.getValue());
        }

        public abstract String getDisplayText();

        protected void childCreated(TraceObjectValue value) {
            if (this.getParent() == null || !this.isLoaded()) {
                return;
            }
            if (ObjectTreeModel.this.isValueVisible(value)) {
                AbstractNode child = ObjectTreeModel.this.nodeCache.getOrCreateNode(value);
                this.addNodeSorted(child);
            }
        }

        protected void childDeleted(TraceObjectValue value) {
            if (this.getParent() == null || !this.isLoaded()) {
                return;
            }
            AbstractNode child = ObjectTreeModel.this.nodeCache.getByValue(value);
            if (child != null) {
                this.removeNode((GTreeNode)child);
            }
        }

        protected AbstractNode getNode(KeyPath p, int pos) {
            if (pos >= p.size()) {
                return this;
            }
            String key = p.key(pos);
            AbstractNode matched = this.children().stream().map(c -> (AbstractNode)((Object)c)).filter(c -> key.equals(c.getValue().getEntryKey())).findFirst().orElse(null);
            if (matched == null) {
                return null;
            }
            return matched.getNode(p, pos + 1);
        }

        public AbstractNode getNode(KeyPath p) {
            return this.getNode(p, 0);
        }

        protected boolean isModified() {
            return ObjectTreeModel.this.isValueModified(this.getValue());
        }

        protected synchronized void reloadChildrenNow() {
            GTreeNode nc;
            if (!this.isLoaded()) {
                return;
            }
            List current = List.copyOf(this.children());
            List generated = this.generateChildren();
            int ic = 0;
            int ig = 0;
            int diff = 0;
            while (ic < current.size() && ig < generated.size()) {
                GTreeNode ng;
                nc = (GTreeNode)current.get(ic);
                if (nc == (ng = (GTreeNode)generated.get(ig))) {
                    ++ic;
                    ++ig;
                    continue;
                }
                int comp = nc.compareTo(ng);
                if (comp == 0) {
                    this.addNode(ic + diff, ng);
                    this.removeNode(nc);
                    ++ic;
                    ++ig;
                    continue;
                }
                if (comp < 0) {
                    this.removeNode(nc);
                    --diff;
                    ++ic;
                    continue;
                }
                this.addNode(ic + diff, ng);
                ++diff;
                ++ig;
            }
            while (ic < current.size()) {
                nc = (GTreeNode)current.get(ic);
                this.removeNode(nc);
                ++ic;
            }
            while (ig < generated.size()) {
                GTreeNode ng = (GTreeNode)generated.get(ig);
                this.addNode(ic + diff, ng);
                ++diff;
                ++ig;
            }
        }
    }

    static interface LastKeyDisplaysObjectValues
    extends DisplaysObjectValues {
        @Override
        default public String getRawObjectDisplay(TraceObjectValue edge) {
            TraceObject object = edge.getChild();
            if (object.isRoot()) {
                return "Root";
            }
            if (edge.isCanonical()) {
                return edge.getEntryKey();
            }
            return object.getCanonicalPath().toString();
        }
    }

    public class CanonicalNode
    extends AbstractObjectNode {
        public CanonicalNode(TraceObjectValue value) {
            super(value);
        }

        protected List<GTreeNode> generateChildren() {
            return ObjectTreeModel.this.generateObjectChildren(this.object);
        }

        @Override
        public String getDisplayText() {
            return "<html>" + HTMLUtilities.escapeHTML((String)ObjectTreeModel.this.display.getObjectDisplay(this.value), (boolean)true);
        }

        public String getToolTip() {
            return ObjectTreeModel.this.display.getObjectToolTip(this.value);
        }

        @Override
        public Icon getIcon(boolean expanded) {
            TraceObjectValue parentValue = this.object.getCanonicalParent(ObjectTreeModel.this.snap);
            if (parentValue == null) {
                return super.getIcon(expanded);
            }
            if (!parentValue.getParent().getSchema().isCanonicalContainer()) {
                return super.getIcon(expanded);
            }
            if (!ObjectTreeModel.this.isOnEventPath(this.object)) {
                return super.getIcon(expanded);
            }
            return DebuggerResources.ICON_EVENT_MARKER;
        }

        public boolean isLeaf() {
            return false;
        }
    }

    public class LinkNode
    extends AbstractObjectNode {
        public LinkNode(TraceObjectValue value) {
            super(value);
        }

        @Override
        public String getDisplayText() {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.value.getEntryKey(), (boolean)true) + ":&nbsp;<em>" + HTMLUtilities.escapeHTML((String)ObjectTreeModel.this.display.getObjectLinkDisplay(this.value), (boolean)true) + "</em>";
        }

        public String getToolTip() {
            return ObjectTreeModel.this.display.getObjectLinkToolTip(this.value);
        }

        public boolean isLeaf() {
            return true;
        }

        protected List<GTreeNode> generateChildren() {
            return List.of();
        }

        @Override
        protected void childCreated(TraceObjectValue value) {
            throw new AssertionError();
        }

        @Override
        protected void childDeleted(TraceObjectValue value) {
            throw new AssertionError();
        }
    }

    public abstract class AbstractObjectNode
    extends AbstractNode {
        protected final TraceObjectValue value;
        protected final TraceObject object;

        public AbstractObjectNode(TraceObjectValue value) {
            this.value = value;
            this.object = Objects.requireNonNull(value.getChild());
        }

        @Override
        public TraceObjectValue getValue() {
            return this.value;
        }

        public Icon getIcon(boolean expanded) {
            return ObjectTreeModel.this.getObjectIcon(this.value, expanded);
        }
    }

    public class PrimitiveNode
    extends AbstractNode {
        protected final TraceObjectValue value;

        public PrimitiveNode(TraceObjectValue value) {
            this.value = value;
        }

        @Override
        public TraceObjectValue getValue() {
            return this.value;
        }

        protected List<GTreeNode> generateChildren() {
            return List.of();
        }

        @Override
        public String getDisplayText() {
            String html = HTMLUtilities.escapeHTML((String)(this.value.getEntryKey() + ": " + ObjectTreeModel.this.display.getPrimitiveValueDisplay(this.value.getValue())), (boolean)true);
            return "<html>" + html;
        }

        public Icon getIcon(boolean expanded) {
            return DebuggerResources.ICON_OBJECT_UNPOPULATED;
        }

        public String getToolTip() {
            return ObjectTreeModel.this.display.getPrimitiveEdgeToolTip(this.value);
        }

        public boolean isLeaf() {
            return true;
        }
    }

    public static class PendingNode
    extends GTreeLazyNode {
        public String getName() {
            return "";
        }

        public String getDisplayText() {
            return "Refreshing...";
        }

        public Icon getIcon(boolean expanded) {
            return ICON_PENDING;
        }

        public boolean isLeaf() {
            return true;
        }

        protected List<GTreeNode> generateChildren() {
            return List.of();
        }

        public String getToolTip() {
            return null;
        }
    }
}

