/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.trace.TracePcodeExecutorState;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.trace.model.guest.TracePlatform;

public interface TracePcodeMachine<T>
extends PcodeMachine<T> {
    public TracePcodeExecutorState<T> createSharedState();

    public TracePcodeExecutorState<T> createLocalState(PcodeThread<T> var1);

    default public void writeDown(PcodeTraceAccess into) {
        TracePcodeExecutorState sharedState = (TracePcodeExecutorState)this.getSharedState();
        sharedState.writeDown(into.getDataForSharedState());
        for (PcodeThread emuThread : this.getAllThreads()) {
            PcodeTraceRegistersAccess localInto = into.getDataForLocalState(emuThread, 0);
            if (localInto == null) {
                throw new IllegalArgumentException("Given trace does not have thread with name/path '" + emuThread.getName() + "' at source snap");
            }
            TracePcodeExecutorState localState = (TracePcodeExecutorState)emuThread.getState().getLocalState();
            localState.writeDown(localInto);
        }
    }

    default public void writeDown(TracePlatform platform, long destSnap, long threadsSnap) {
        this.writeDown(new DefaultPcodeTraceAccess(platform, destSnap, threadsSnap));
    }
}

