/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import ghidra.feature.vt.api.correlator.program.CombinedFunctionAndDataReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.DataReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.DuplicateFunctionMatchProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactDataMatchProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchBytesProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchInstructionsProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchMnemonicsProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.FunctionReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.SymbolNameProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.VTAbstractReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.task.ApplyMarkupItemTask;
import ghidra.feature.vt.gui.util.ImpliedMatchUtils;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.MatchInfoFactory;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoVersionTrackingTask
extends Task {
    private static final String NAME = "Auto Version Tracking Command";
    private VTSession session;
    private MatchInfoFactory matchInfoFactory;
    private AddressCorrelatorManager addressCorrelator;
    private Program sourceProgram;
    private Program destinationProgram;
    private AddressSetView sourceAddressSet;
    private AddressSetView destinationAddressSet;
    private ToolOptions toolOptions;
    private String statusMsg = null;
    private static int NUM_CORRELATORS = 8;

    public AutoVersionTrackingTask(VTSession session, ToolOptions toolOptions) {
        super(NAME, true, true, true);
        this.session = session;
        this.matchInfoFactory = new MatchInfoFactory();
        this.addressCorrelator = new AddressCorrelatorManager(() -> session);
        this.sourceProgram = session.getSourceProgram();
        this.destinationProgram = session.getDestinationProgram();
        this.toolOptions = toolOptions;
    }

    public int getStatusTextAlignment() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) throws CancelledException {
        boolean error = true;
        int id = this.session.startTransaction(NAME);
        try {
            this.session.setEventsEnabled(false);
            this.doRun(monitor);
            error = false;
        }
        catch (CancelledException e) {
            try {
                error = false;
            }
            catch (Throwable throwable) {
                this.session.setEventsEnabled(true);
                this.session.endTransaction(id, !error);
                throw throwable;
            }
            this.session.setEventsEnabled(true);
            this.session.endTransaction(id, !error);
        }
        this.session.setEventsEnabled(true);
        this.session.endTransaction(id, !error);
    }

    private void doRun(TaskMonitor realMonitor) throws CancelledException {
        boolean autoCreateImpliedMatches;
        boolean runRefCorrelators;
        boolean runDupeFunctionCorrelator;
        boolean runExactFunctionInstCorrelator;
        boolean runExactDataCorrelator;
        VTOptions vtOptions;
        SubTaskMonitor monitor = new SubTaskMonitor(this, realMonitor);
        boolean hasApplyErrors = false;
        this.sourceAddressSet = this.sourceProgram.getMemory().getLoadedAndInitializedAddressSet();
        this.destinationAddressSet = this.destinationProgram.getMemory().getLoadedAndInitializedAddressSet();
        int count = 0;
        monitor.doInitialize(NUM_CORRELATORS);
        boolean originalImpliedMatchOption = this.toolOptions.getBoolean("Accept Match Options.Auto Create Implied Matches", false);
        this.toolOptions.setBoolean("Accept Match Options.Auto Create Implied Matches", false);
        String prefix = "%s correlation (%d of " + NUM_CORRELATORS + ") - ";
        boolean runExactSymbolCorrelator = this.toolOptions.getBoolean("Auto Version Tracking Options.Run Exact Symbol Correlator", true);
        if (runExactSymbolCorrelator) {
            SymbolNameProgramCorrelatorFactory factory = new SymbolNameProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            int symbolMin = this.toolOptions.getInt("Auto Version Tracking Options.Symbol Correlator Options.Symbol Correlator Minimum Symbol Length", 3);
            vtOptions.setInt("Minimum Symbol Name Length", symbolMin);
            monitor.setPrefix(String.format(prefix, "Symbol Name", ++count));
            hasApplyErrors = this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
        }
        if (runExactDataCorrelator = this.toolOptions.getBoolean("Auto Version Tracking Options.Run Exact Data Correlator", true)) {
            ExactDataMatchProgramCorrelatorFactory factory = new ExactDataMatchProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            int dataMin = this.toolOptions.getInt("Auto Version Tracking Options.Data Correlator Options.Data Correlator Minimum Data Length", 5);
            vtOptions.setInt("Data Minimum Size", dataMin);
            monitor.setPrefix(String.format(prefix, "Exact Data", ++count));
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
        }
        int minFunctionLen = this.toolOptions.getInt("Auto Version Tracking Options.Exact Function Correlators Options.Exact Function Correlators Minimum Function Length", 10);
        boolean runExactFunctionBytesCorrelator = this.toolOptions.getBoolean("Auto Version Tracking Options.Run Exact Function Bytes Correlator", true);
        if (runExactFunctionBytesCorrelator) {
            ExactMatchBytesProgramCorrelatorFactory factory = new ExactMatchBytesProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            vtOptions.setInt("Function Minimum Size", minFunctionLen);
            monitor.setPrefix(String.format(prefix, "Exact Bytes", ++count));
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
        }
        if (runExactFunctionInstCorrelator = this.toolOptions.getBoolean("Auto Version Tracking Options.Run Exact Function Instructions Correlators", true)) {
            VTAbstractProgramCorrelatorFactory factory = new ExactMatchInstructionsProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            vtOptions.setInt("Function Minimum Size", minFunctionLen);
            monitor.setPrefix(String.format(prefix, "Exact Instructions", ++count));
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
            factory = new ExactMatchMnemonicsProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            vtOptions.setInt("Function Minimum Size", minFunctionLen);
            monitor.setPrefix(String.format(prefix, "Exact Mnemonic", ++count));
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
        }
        if (runDupeFunctionCorrelator = this.toolOptions.getBoolean("Auto Version Tracking Options.Run Duplicate Function Correlator", true)) {
            DuplicateFunctionMatchProgramCorrelatorFactory factory = new DuplicateFunctionMatchProgramCorrelatorFactory();
            vtOptions = factory.createDefaultOptions();
            int dupFunctionMinLen = this.toolOptions.getInt("Auto Version Tracking Options.Duplicate Function Correlator Options.Duplicate Function Correlator Minimum Function Length", 25);
            vtOptions.setInt("Function Minimum Size", dupFunctionMinLen);
            monitor.setPrefix(String.format(prefix, "Duplicate Function", ++count));
            hasApplyErrors |= this.correlateAndPossiblyApplyDuplicateFunctions(factory, vtOptions, (TaskMonitor)monitor);
            monitor.doIncrementProgress();
        }
        if (runRefCorrelators = this.toolOptions.getBoolean("Auto Version Tracking Options.Run the Reference Correlators", true)) {
            VTAbstractReferenceProgramCorrelatorFactory factory;
            double minScore = this.toolOptions.getDouble("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Score", 0.95);
            double minConf = this.toolOptions.getDouble("Auto Version Tracking Options.Reference Correlators Options.Reference Correlators Minimum Confidence", 10.0);
            int numDataMatches = this.getNumberOfDataMatches((TaskMonitor)monitor);
            int numFunctionMatches = this.getNumberOfFunctionMatches((TaskMonitor)monitor);
            if (numDataMatches > 0 && numFunctionMatches == 0) {
                factory = new DataReferenceProgramCorrelatorFactory();
                vtOptions = factory.createDefaultOptions();
                vtOptions.setDouble("Confidence threshold (info content)", minConf);
                vtOptions.setDouble("Minimum similarity threshold (score)", minScore);
                monitor.setPrefix(String.format(prefix, "Data Reference", ++count));
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
                monitor.doIncrementProgress();
                numDataMatches = this.getNumberOfDataMatches((TaskMonitor)monitor);
                numFunctionMatches = this.getNumberOfFunctionMatches((TaskMonitor)monitor);
            }
            if (numDataMatches > 0 && numFunctionMatches == 0) {
                factory = new FunctionReferenceProgramCorrelatorFactory();
                vtOptions = factory.createDefaultOptions();
                vtOptions.setDouble("Confidence threshold (info content)", minConf);
                vtOptions.setDouble("Minimum similarity threshold (score)", minScore);
                factory = new FunctionReferenceProgramCorrelatorFactory();
                monitor.setPrefix(String.format(prefix, "Function Reference", ++count));
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
                monitor.doIncrementProgress();
                numDataMatches = this.getNumberOfDataMatches((TaskMonitor)monitor);
                numFunctionMatches = this.getNumberOfFunctionMatches((TaskMonitor)monitor);
            }
            if (numDataMatches > 0 && numFunctionMatches > 0) {
                factory = new CombinedFunctionAndDataReferenceProgramCorrelatorFactory();
                vtOptions = factory.createDefaultOptions();
                vtOptions.setDouble("Confidence threshold (info content)", minConf);
                vtOptions.setDouble("Minimum similarity threshold (score)", minScore);
                monitor.setPrefix(String.format(prefix, "Function and Data", ++count));
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, vtOptions, (TaskMonitor)monitor);
                monitor.doIncrementProgress();
            }
        }
        if (autoCreateImpliedMatches = this.toolOptions.getBoolean("Auto Version Tracking Options.Create Implied Matches", false)) {
            boolean applyImpliedMatches = this.toolOptions.getBoolean("Auto Version Tracking Options.Implied Match Correlator Options.Apply Implied Matches", true);
            int minVotes = this.toolOptions.getInt("Auto Version Tracking Options.Implied Match Correlator Options.Minimum Votes Needed", 2);
            int maxConflicts = this.toolOptions.getInt("Auto Version Tracking Options.Implied Match Correlator Options.Maximum Conflicts Allowed", 2);
            hasApplyErrors |= this.createImpliedMatches(applyImpliedMatches, minVotes, maxConflicts, (TaskMonitor)monitor);
        }
        String applyMarkupStatus = " with no apply markup errors.";
        if (hasApplyErrors) {
            applyMarkupStatus = " with some apply markup errors. See the log or the markup table for more details";
        }
        this.statusMsg = "Auto Version Tracking Command completed successfully" + applyMarkupStatus;
        this.toolOptions.setBoolean("Accept Match Options.Auto Create Implied Matches", originalImpliedMatchOption);
    }

    private boolean createImpliedMatches(boolean applyGoodMatches, int minVotes, int maxConflicts, TaskMonitor monitor) throws CancelledException {
        HashSet<VTAssociation> processedSrcDestPairs = new HashSet<VTAssociation>();
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        monitor.setMessage("Creating Implied Matches...");
        monitor.initialize((long)matchSets.size());
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCancelled();
            Collection<VTMatch> matches = matchSet.getMatches();
            this.createImpliedMatches(monitor, processedSrcDestPairs, matches);
            monitor.incrementProgress();
        }
        if (!applyGoodMatches) {
            return false;
        }
        boolean hasApplyErrors = false;
        VTMatchSet impliedMatchSet = this.session.getImpliedMatchSet();
        Set<VTMatch> goodImpliedMatches = this.findGoodImpliedMatches(impliedMatchSet.getMatches(), minVotes, maxConflicts, monitor);
        while (goodImpliedMatches.size() > 0) {
            monitor.checkCancelled();
            hasApplyErrors |= this.applyMatches(goodImpliedMatches, monitor);
            this.createImpliedMatches(monitor, processedSrcDestPairs, goodImpliedMatches);
            impliedMatchSet = this.session.getImpliedMatchSet();
            goodImpliedMatches = this.findGoodImpliedMatches(impliedMatchSet.getMatches(), minVotes, maxConflicts, monitor);
        }
        return hasApplyErrors;
    }

    private void createImpliedMatches(TaskMonitor monitor, Set<VTAssociation> processedSrcDestPairs, Collection<VTMatch> matches) throws CancelledException {
        for (VTMatch match : matches) {
            MatchInfo matchInfo;
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            if (association.getType() == VTAssociationType.DATA || association.getStatus() != VTAssociationStatus.ACCEPTED || processedSrcDestPairs.contains(association) || (matchInfo = this.matchInfoFactory.getMatchInfo(match, this.addressCorrelator)).getSourceFunction() == null || matchInfo.getDestinationFunction() == null) continue;
            ImpliedMatchUtils.updateImpliedMatchForAcceptedAssocation(matchInfo.getSourceFunction(), matchInfo.getDestinationFunction(), this.session, this.addressCorrelator, monitor);
            processedSrcDestPairs.add(association);
        }
    }

    private Set<VTMatch> findGoodImpliedMatches(Collection<VTMatch> matchesToProcess, int minVoteCountNeeded, int maxConflictsAllowed, TaskMonitor monitor) throws CancelledException {
        HashSet<VTMatch> goodImpliedMatches = new HashSet<VTMatch>();
        for (VTMatch match : matchesToProcess) {
            int numConflicts;
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            if (association.getStatus() != VTAssociationStatus.AVAILABLE || (numConflicts = association.getRelatedAssociations().size() - 1) > maxConflictsAllowed) continue;
            int voteCount = association.getVoteCount();
            if (voteCount >= minVoteCountNeeded) {
                goodImpliedMatches.add(match);
            }
            monitor.incrementProgress();
        }
        return goodImpliedMatches;
    }

    private int getNumberOfDataMatches(TaskMonitor monitor) throws CancelledException {
        int numDataMatches = 0;
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCancelled();
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch match : matches) {
                monitor.checkCancelled();
                if (match.getAssociation().getStatus() != VTAssociationStatus.ACCEPTED || match.getAssociation().getType() != VTAssociationType.DATA) continue;
                ++numDataMatches;
            }
        }
        return numDataMatches;
    }

    private int getNumberOfFunctionMatches(TaskMonitor monitor) throws CancelledException {
        int numFunctionMatches = 0;
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCancelled();
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch match : matches) {
                monitor.checkCancelled();
                if (match.getAssociation().getStatus() != VTAssociationStatus.ACCEPTED || match.getAssociation().getType() != VTAssociationType.FUNCTION) continue;
                ++numFunctionMatches;
            }
        }
        return numFunctionMatches;
    }

    private boolean correlateAndPossiblyApply(VTProgramCorrelatorFactory factory, VTOptions options, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        monitor.setMessage("Finding and applying good " + factory.getName() + " matches and markup.");
        VTProgramCorrelator correlator = factory.createCorrelator(this.sourceProgram, this.sourceAddressSet, this.destinationProgram, this.destinationAddressSet, options);
        VTMatchSet results = correlator.correlate(this.session, monitor);
        monitor.initialize((long)results.getMatchCount());
        boolean hasMarkupErrors = this.applyMatches(results.getMatches(), monitor);
        monitor.incrementProgress(1L);
        return hasMarkupErrors;
    }

    private boolean correlateAndPossiblyApplyDuplicateFunctions(VTProgramCorrelatorFactory factory, VTOptions options, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding and applying good " + factory.getName() + " matches and markup.");
        VTProgramCorrelator correlator = factory.createCorrelator(this.sourceProgram, this.sourceAddressSet, this.destinationProgram, this.destinationAddressSet, options);
        VTMatchSet results = correlator.correlate(this.session, monitor);
        monitor.initialize((long)results.getMatchCount());
        boolean hasMarkupErrors = this.applyDuplicateFunctionMatches(results, monitor);
        monitor.incrementProgress(1L);
        return hasMarkupErrors;
    }

    private boolean applyMatches(Collection<VTMatch> matches, TaskMonitor monitor) throws CancelledException {
        boolean someMatchesHaveMarkupErrors = false;
        for (VTMatch match : matches) {
            MatchInfo matchInfo;
            Collection<VTMarkupItem> markupItems;
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            if (!association.getStatus().canApply()) continue;
            if (this.hasAcceptedRelatedAssociation(association, monitor)) {
                Msg.warn(AutoVersionTrackingTask.class, (Object)("This association has a related association with an accepted match so cannot make this association accepted which would try to block the already accepted related association " + String.valueOf(association)));
                continue;
            }
            if (!AutoVersionTrackingTask.tryToSetAccepted(association) || (markupItems = (matchInfo = this.matchInfoFactory.getMatchInfo(match, this.addressCorrelator)).getAppliableMarkupItems(monitor)) == null || markupItems.size() == 0) continue;
            ApplyMarkupItemTask markupTask = new ApplyMarkupItemTask(this.session, markupItems, this.toolOptions);
            markupTask.run(monitor);
            boolean currentMatchHasErrors = markupTask.hasErrors();
            if (!currentMatchHasErrors) continue;
            someMatchesHaveMarkupErrors = true;
        }
        return someMatchesHaveMarkupErrors;
    }

    private static boolean tryToSetAccepted(VTAssociation association) {
        try {
            association.setAccepted();
            return true;
        }
        catch (VTAssociationStatusException e) {
            Msg.warn(AutoVersionTrackingTask.class, (Object)("Could not set match accepted for " + String.valueOf(association)), (Throwable)e);
            return false;
        }
    }

    private boolean hasAcceptedRelatedAssociation(VTAssociation association, TaskMonitor taskMonitor) throws CancelledException {
        VTAssociationManager vtAssocManager = this.session.getAssociationManager();
        HashSet<VTAssociation> relatedAssociations = new HashSet<VTAssociation>(vtAssocManager.getRelatedAssociationsBySourceAndDestinationAddress(association.getSourceAddress(), association.getDestinationAddress()));
        for (VTAssociation relatedAssociation : relatedAssociations) {
            VTAssociationStatus status;
            taskMonitor.checkCancelled();
            if (relatedAssociation.equals(association) || !(status = relatedAssociation.getStatus()).equals((Object)VTAssociationStatus.ACCEPTED)) continue;
            Msg.debug((Object)((Object)this), (Object)(relatedAssociation.toString() + " is already accepted match."));
            return true;
        }
        return false;
    }

    private boolean applyDuplicateFunctionMatches(VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        Collection<VTMatch> matches = matchSet.getMatches();
        boolean someMatchesHaveMarkupErrors = false;
        HashSet<VTAssociation> processedSrcDestPairs = new HashSet<VTAssociation>();
        String message = "Processing match %d of %d...";
        int n = matches.size();
        Iterator<VTMatch> it = matches.iterator();
        int i = 0;
        while (it.hasNext()) {
            monitor.checkCancelled();
            monitor.setMessage(String.format(message, i, n));
            VTMatch match = it.next();
            VTAssociation association = match.getAssociation();
            if (!processedSrcDestPairs.contains(association)) {
                if (association.getStatus() != VTAssociationStatus.AVAILABLE) {
                    processedSrcDestPairs.add(association);
                } else {
                    Set<VTAssociation> allRelatedAssociations = this.getAllRelatedAssociations(match.getSourceAddress(), match.getDestinationAddress(), monitor);
                    List<VTAssociation> uniqueAssociations = this.findUniqueAssociations(allRelatedAssociations, monitor);
                    processedSrcDestPairs.addAll(allRelatedAssociations);
                    if (uniqueAssociations != null) {
                        for (VTAssociation uniqueAssociation : uniqueAssociations) {
                            monitor.checkCancelled();
                            VTMatch theMatch = this.getAssociationMatchFromMatchSet(uniqueAssociation, matchSet, monitor);
                            if (theMatch == null) {
                                Msg.error((Object)((Object)this), (Object)(uniqueAssociation.toString() + " Should be in the original match set used"));
                                continue;
                            }
                            someMatchesHaveMarkupErrors |= this.tryToAcceptMatchAndApplyMarkup(theMatch, monitor);
                        }
                    }
                }
            }
            ++i;
        }
        return someMatchesHaveMarkupErrors;
    }

    private Set<VTAssociation> getAllRelatedAssociations(Address source, Address destination, TaskMonitor monitor) throws CancelledException {
        VTAssociationManager vtAssocManager = this.session.getAssociationManager();
        Collection<VTAssociation> relatedAssociations = vtAssocManager.getRelatedAssociationsBySourceAndDestinationAddress(source, destination);
        HashSet<VTAssociation> allRelatedAssociations = new HashSet<VTAssociation>(relatedAssociations);
        for (VTAssociation association : relatedAssociations) {
            monitor.checkCancelled();
            allRelatedAssociations.addAll(vtAssocManager.getRelatedAssociationsBySourceAndDestinationAddress(association.getSourceAddress(), association.getDestinationAddress()));
        }
        return allRelatedAssociations;
    }

    private VTMatch getAssociationMatchFromMatchSet(VTAssociation association, VTMatchSet matchSet, TaskMonitor monitor) throws CancelledException {
        ArrayList<VTMatch> assocMatchesInMatchSet = new ArrayList<VTMatch>();
        List<VTMatch> assocationMatches = this.session.getMatches(association);
        Collection<VTMatch> matchSetMatches = matchSet.getMatches();
        for (VTMatch match : assocationMatches) {
            monitor.checkCancelled();
            if (!matchSetMatches.contains(match)) continue;
            assocMatchesInMatchSet.add(match);
        }
        if (assocMatchesInMatchSet.size() == 1) {
            return (VTMatch)assocMatchesInMatchSet.get(0);
        }
        Msg.error((Object)((Object)this), (Object)("Expected single match in matchset for association " + association.toString()));
        return null;
    }

    private List<VTAssociation> findUniqueAssociations(Collection<VTAssociation> relatedAssociations, TaskMonitor monitor) throws CancelledException {
        Map<Function, Map<Long, Map<Integer, Object>>> sourceFunctionsMap = this.createFunctionsMap(relatedAssociations, true, monitor);
        Map<Function, Map<Long, Map<Integer, Object>>> destFunctionsMap = this.createFunctionsMap(relatedAssociations, false, monitor);
        if (sourceFunctionsMap.isEmpty() || destFunctionsMap.isEmpty()) {
            return null;
        }
        List<VTAssociation> uniqueAssociations = this.findUniqueAssociationsUsingMaps(sourceFunctionsMap, destFunctionsMap, monitor);
        return uniqueAssociations;
    }

    private List<VTAssociation> findUniqueAssociationsUsingMaps(Map<Function, Map<Long, Map<Integer, Object>>> sourceFunctionsMap, Map<Function, Map<Long, Map<Integer, Object>>> destFunctionsMap, TaskMonitor monitor) throws CancelledException {
        ArrayList<VTAssociation> uniqueAssociations = new ArrayList<VTAssociation>();
        VTAssociationManager vtAssocManager = this.session.getAssociationManager();
        Set<Function> sourceFunctions = sourceFunctionsMap.keySet();
        HashSet<Function> matchedDestFunctions = new HashSet<Function>();
        for (Function sourceFunction : sourceFunctions) {
            monitor.checkCancelled();
            Map<Long, Map<Integer, Object>> sourceFunctionMap = sourceFunctionsMap.get(sourceFunction);
            Function destFunction = this.getSingleMatch(sourceFunctionMap, destFunctionsMap, matchedDestFunctions, monitor);
            if (destFunction == null) continue;
            matchedDestFunctions.add(destFunction);
            VTAssociation association = vtAssocManager.getAssociation(sourceFunction.getEntryPoint(), destFunction.getEntryPoint());
            if (association == null) continue;
            uniqueAssociations.add(association);
        }
        return uniqueAssociations;
    }

    private Map<Function, Map<Long, Map<Integer, Object>>> createFunctionsMap(Collection<VTAssociation> associations, boolean source, TaskMonitor monitor) throws CancelledException {
        HashMap<Function, Map<Long, Map<Integer, Object>>> functionsMap = new HashMap<Function, Map<Long, Map<Integer, Object>>>();
        HashSet<Function> functionsMapAttempted = new HashSet<Function>();
        for (VTAssociation association : associations) {
            monitor.checkCancelled();
            Function function = null;
            function = source ? this.getSourceFunction(association) : this.getDestFunction(association);
            if (function == null || functionsMapAttempted.contains(function)) continue;
            functionsMapAttempted.add(function);
            Map<Long, Map<Integer, Object>> map = this.mapFunctionScalarAndAddressOperands(function, monitor);
            if (map == null) continue;
            functionsMap.put(function, map);
        }
        return functionsMap;
    }

    private Function getSingleMatch(Map<Long, Map<Integer, Object>> sourceFunctionMap, Map<Function, Map<Long, Map<Integer, Object>>> destFunctionsMap, Set<Function> destFunctionsToOmit, TaskMonitor monitor) throws CancelledException {
        Set<Function> destFunctions = destFunctionsMap.keySet();
        HashSet<Function> matchingFunctions = new HashSet<Function>();
        destFunctions.removeAll(destFunctionsToOmit);
        for (Function destFunction : destFunctions) {
            monitor.checkCancelled();
            Map<Long, Map<Integer, Object>> destFunctionMap = destFunctionsMap.get(destFunction);
            if (!this.equalsFunctionMap(sourceFunctionMap, destFunctionMap, monitor)) continue;
            matchingFunctions.add(destFunction);
        }
        if (matchingFunctions.size() == 1) {
            ArrayList list = new ArrayList(matchingFunctions);
            return (Function)list.get(0);
        }
        return null;
    }

    private boolean equalsFunctionMap(Map<Long, Map<Integer, Object>> map1, Map<Long, Map<Integer, Object>> map2, TaskMonitor monitor) throws CancelledException {
        if (!map1.keySet().equals(map2.keySet())) {
            return false;
        }
        Set<Long> map1Longs = map1.keySet();
        for (Long offset : map1Longs) {
            Map<Integer, Object> opMap2;
            Map<Integer, Object> opMap1 = map1.get(offset);
            if (this.equivalentOperandMap(opMap1, opMap2 = map2.get(offset), monitor)) continue;
            return false;
        }
        return true;
    }

    private boolean equivalentOperandMap(Map<Integer, Object> map1, Map<Integer, Object> map2, TaskMonitor monitor) throws CancelledException {
        if (!map1.keySet().equals(map2.keySet())) {
            return false;
        }
        for (Integer i : map1.keySet()) {
            Object op2;
            monitor.checkCancelled();
            Object op1 = map1.get(i);
            if (this.equivalentOperands(op1, op2 = map2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equivalentOperands(Object op1, Object op2) {
        if (op1 instanceof Scalar) {
            return op1.equals(op2);
        }
        return this.isEquivalentAddressOperand(op1, op2);
    }

    private boolean isEquivalentAddressOperand(Object op1, Object op2) {
        if (!(op1 instanceof Address)) {
            return false;
        }
        if (!(op2 instanceof Address)) {
            return false;
        }
        Address addr1 = (Address)op1;
        Address addr2 = (Address)op2;
        VTAssociation association = this.session.getAssociationManager().getAssociation(addr1, addr2);
        if (association != null) {
            return true;
        }
        if (this.hasAnyAssociations(addr1, addr2)) {
            return false;
        }
        return this.isSameOperandType(addr1, addr2);
    }

    private boolean isSameOperandType(Address addr1, Address addr2) {
        Function function1 = this.sourceProgram.getFunctionManager().getFunctionAt(addr1);
        if (function1 != null) {
            Function function2 = this.destinationProgram.getFunctionManager().getFunctionAt(addr2);
            return function2 != null;
        }
        Data data1 = this.sourceProgram.getListing().getDataAt(addr1);
        if (data1 != null && data1.isDefined()) {
            Data data2 = this.destinationProgram.getListing().getDataAt(addr2);
            if (data2 == null) {
                return false;
            }
            if (!data2.isDefined()) {
                return false;
            }
            if (data1.getDataType().getName().equals(data2.getDataType().getName())) {
                return true;
            }
        }
        return false;
    }

    private boolean hasAnyAssociations(Address source, Address dest) {
        Collection<VTAssociation> sourceAssociations = this.session.getAssociationManager().getRelatedAssociationsBySourceAddress(source);
        if (!sourceAssociations.isEmpty()) {
            return true;
        }
        Collection<VTAssociation> destAssociations = this.session.getAssociationManager().getRelatedAssociationsByDestinationAddress(dest);
        return !destAssociations.isEmpty();
    }

    private Function getSourceFunction(VTAssociation association) {
        Address address = association.getSourceAddress();
        return this.sourceProgram.getFunctionManager().getFunctionAt(address);
    }

    private Function getDestFunction(VTAssociation association) {
        Address address = association.getDestinationAddress();
        return this.destinationProgram.getFunctionManager().getFunctionAt(address);
    }

    private Map<Long, Map<Integer, Object>> mapFunctionScalarAndAddressOperands(Function function, TaskMonitor monitor) throws CancelledException {
        HashMap<Long, Map<Integer, Object>> offsetToOperandsMap = new HashMap<Long, Map<Integer, Object>>();
        Program program = function.getProgram();
        InstructionIterator func1InstIter = program.getListing().getInstructions(function.getBody(), true);
        while (func1InstIter.hasNext()) {
            monitor.checkCancelled();
            Instruction inst = func1InstIter.next();
            Map<Integer, Object> map = this.createOperandsMap(inst);
            if (map.keySet().isEmpty()) continue;
            Long entryOffset = function.getEntryPoint().getOffset();
            Long instOffset = inst.getAddress().getOffset();
            Long offset = instOffset - entryOffset;
            offsetToOperandsMap.put(offset, map);
        }
        if (offsetToOperandsMap.keySet().isEmpty()) {
            return null;
        }
        return offsetToOperandsMap;
    }

    private Map<Integer, Object> createOperandsMap(Instruction inst) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int numOperands = inst.getNumOperands();
        for (int opIndex = 0; opIndex < numOperands; ++opIndex) {
            int opType = inst.getOperandType(opIndex);
            if (OperandType.isScalar((int)opType)) {
                map.put(opIndex, inst.getScalar(opIndex));
                continue;
            }
            if (!OperandType.isAddress((int)opType)) continue;
            if (OperandType.isDataReference((int)opType)) {
                map.put(opIndex, inst.getAddress(opIndex));
                continue;
            }
            if (!OperandType.isCodeReference((int)opType)) continue;
            map.put(opIndex, inst.getAddress(opIndex));
        }
        return map;
    }

    private boolean tryToAcceptMatchAndApplyMarkup(VTMatch match, TaskMonitor monitor) throws CancelledException {
        VTAssociation association = match.getAssociation();
        if (association.getStatus() == VTAssociationStatus.AVAILABLE) {
            MatchInfo matchInfo;
            Collection<VTMarkupItem> markupItems;
            if (this.hasAcceptedRelatedAssociation(association, monitor)) {
                Msg.warn(AutoVersionTrackingTask.class, (Object)("This association has a related association with an accepted match so cannot make this association accepted which would try to block the already accepted related association " + String.valueOf(association)));
                return false;
            }
            if (AutoVersionTrackingTask.tryToSetAccepted(association) && (markupItems = (matchInfo = this.matchInfoFactory.getMatchInfo(match, this.addressCorrelator)).getAppliableMarkupItems(monitor)) != null && markupItems.size() != 0) {
                ApplyMarkupItemTask markupTask = new ApplyMarkupItemTask(this.session, markupItems, this.toolOptions);
                markupTask.run(monitor);
                boolean currentMatchHasErrors = markupTask.hasErrors();
                if (currentMatchHasErrors) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    private class SubTaskMonitor
    extends WrappingTaskMonitor {
        private String prefix;

        SubTaskMonitor(AutoVersionTrackingTask autoVersionTrackingTask, TaskMonitor delegate) {
            super(delegate);
        }

        void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        void doIncrementProgress() {
            super.incrementProgress(1L);
        }

        void doInitialize(long max) {
            super.initialize(max);
        }

        public void setMessage(String message) {
            super.setMessage(this.prefix + message);
        }

        public void initialize(long max) {
        }

        public synchronized void setMaximum(long max) {
        }

        public void setProgress(long value) {
        }

        public void incrementProgress(long incrementAmount) {
        }
    }
}

